package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.SysMessageSalary;
import com.yifu.cloud.plus.v1.yifu.salary.service.SysMessageSalaryService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SysMessageSalarySearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * @Author fxj
 * @Description 最低工资提醒-每月更新一次
 * @Date 17:59 2022/8/17
**/
@RestController
@AllArgsConstructor
@RequestMapping("/sysmessagesalary")
@Tag(name = "最低工资提醒-每月更新一次")
@Slf4j
public class SysMessageSalaryController {

    private final SysMessageSalaryService sysMessageSalaryService;
	private final MenuUtil menuUtil;
    /**
     * 简单分页查询
     * @param page             分页对象
     * @param sysMessageSalary 最低工资提醒-每月更新一次
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<SysMessageSalary>> getSysMessageSalaryPage(Page<SysMessageSalary> page, SysMessageSalary sysMessageSalary) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, sysMessageSalary);
		if (Common.isNotNull(sysMessageSalary.getAuthSql()) && sysMessageSalary.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			sysMessageSalary.setAuthSql(sysMessageSalary.getAuthSql().replace(CommonConstants.A_DEPT_ID, "a.DEPART_ID"));
		}
        return new R<>(sysMessageSalaryService.getSysMessageSalaryPage(page, sysMessageSalary));
    }

    /**
     * 简单分页查询
     *
     * @param page             分页对象
     * @param sysMessageSalary 最低工资提醒-每月更新一次
     * @return 查询所有数据，没有数据权限
     */
    @Operation(description = "处理反馈简单分页查询")
    @GetMapping("/handle/page")
    public R<IPage<SysMessageSalary>> getSysMessageSalaryHandlePage(Page<SysMessageSalary> page, SysMessageSalary sysMessageSalary) {
        return new R<>(sysMessageSalaryService.getSysMessageSalaryHandlePage(page, sysMessageSalary));
    }

    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "id查询")
    @GetMapping("/{id}")
    public R<SysMessageSalary> getById(@PathVariable("id") String id) {
        return new R<>(sysMessageSalaryService.getById(id));
    }

    /**
     * @Author fxj
     * @Description 生成最低工资提醒
     * @Date 18:00 2022/8/17
    **/
    @Inner
    @Operation(description = "生成最低工资提醒")
    @PostMapping("/inner/createSysMessageSalary")
    public void createSysMessageSalary() {
        //薪资月份
        String salaryMonth = DateUtil.addMonth(-1);
        //1：删除当前结算月数据：
        sysMessageSalaryService.deleteAllBySettleMonth(salaryMonth);
        //2:开始生成：
        //2.1：普通工资
        sysMessageSalaryService.insertSalaryBySettleMonth(salaryMonth);
    }

    /**
     * @Author fxj
     * @Description 为了生成之前的月份
     * @Date 18:00 2022/8/17
    **/
    @Operation(description = "生成最低工资提醒外部接口调用")
    @SysLog("生成最低工资提醒外部接口调用")
    @PostMapping("/handle/createSysMessageSalary")
    public void handleCreateSysMessageSalary(String settleMonth) {
        //1：删除当前结算月数据：
        sysMessageSalaryService.deleteAllBySettleMonth(settleMonth);
        //2:开始生成：
        //2.1：普通工资
        sysMessageSalaryService.insertSalaryBySettleMonth(settleMonth);
    }

	/**
	 * @Author fxj
	 * @Description 最低工资提醒导出
	 * @Date 15:28 2022/8/17
	 * @Param
	 * @return
	 **/
	@SysLog("最低工资提醒导出")
	@Operation(description = "最低工资提醒导出")
	@PostMapping("/export")
	public void export(HttpServletResponse response,
					   @RequestBody SysMessageSalarySearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		if (Common.isNotNull(searchVo.getAuthSql()) && searchVo.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			searchVo.setAuthSql(searchVo.getAuthSql().replace(CommonConstants.A_DEPT_ID, "a.DEPART_ID"));
		}
		sysMessageSalaryService.listExport(response,searchVo);
	}

	/**
	 * @Author fxj
	 * @Description  只有创建人为自己才能反馈
	 * @Date 17:15 2022/8/17
	 * @Param
	 * @return
	 **/
	@Operation(description = "最低工资提醒反馈")
	@SysLog("最低工资提醒反馈")
	@PostMapping("/feedback")
	public R<String> feedback(@RequestParam(name = "id",required = true) String id,
							  @RequestParam(name = "reasonType",required = true) Integer reasonType,
							  @RequestParam(name = "feedBack",required = true) String feedBack) {
		return sysMessageSalaryService.feedback(reasonType,id,feedBack);
	}

}
