/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmpModLog;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryEmpModLogService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryEmpModLogSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 薪资人员档案变更记录
 *
 * @author fxj
 * @date 2023-10-11 17:48:31
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsalaryempmodlog" )
@Tag(name = "薪资人员档案变更记录管理")
public class TSalaryEmpModLogController {

    private final TSalaryEmpModLogService tSalaryEmpModLogService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tSalaryEmpModLog 薪资人员档案变更记录
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TSalaryEmpModLog>> getTSalaryEmpModLogPage(Page<TSalaryEmpModLog> page, TSalaryEmpModLogSearchVo tSalaryEmpModLog) {
        return  new R<>(tSalaryEmpModLogService.getTSalaryEmpModLogPage(page,tSalaryEmpModLog));
    }
    /**
     * 不分页查询
     * @param tSalaryEmpModLog 薪资人员档案变更记录
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<TSalaryEmpModLog>> getTSalaryEmpModLogNoPage(@RequestBody TSalaryEmpModLogSearchVo tSalaryEmpModLog) {
        return R.ok(tSalaryEmpModLogService.noPageDiy(tSalaryEmpModLog));
    }

    /**
     * 通过id查询薪资人员档案变更记录
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tsalaryempmodlog_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tsalaryempmodlog_get')" )
    public R<TSalaryEmpModLog> getById(@PathVariable("id" ) String id) {
        return R.ok(tSalaryEmpModLogService.getById(id));
    }

    /**
     * 新增薪资人员档案变更记录
     * @param tSalaryEmpModLog 薪资人员档案变更记录
     * @return R
     */
    @Operation(summary = "新增薪资人员档案变更记录", description = "新增薪资人员档案变更记录：hasPermission('demo_tsalaryempmodlog_add')")
    @SysLog("新增薪资人员档案变更记录" )
    @PostMapping
    public R<Boolean> save(@RequestBody TSalaryEmpModLog tSalaryEmpModLog) {
        return R.ok(tSalaryEmpModLogService.save(tSalaryEmpModLog));
    }

    /**
     * 修改薪资人员档案变更记录
     * @param tSalaryEmpModLog 薪资人员档案变更记录
     * @return R
     */
    @Operation(summary = "修改薪资人员档案变更记录", description = "修改薪资人员档案变更记录：hasPermission('demo_tsalaryempmodlog_edit')")
    @SysLog("修改薪资人员档案变更记录" )
    @PutMapping
    public R<Boolean> updateById(@RequestBody TSalaryEmpModLog tSalaryEmpModLog) {
        return R.ok(tSalaryEmpModLogService.updateById(tSalaryEmpModLog));
    }

    /**
     * 通过id删除薪资人员档案变更记录
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除薪资人员档案变更记录", description = "通过id删除薪资人员档案变更记录：hasPermission('demo_tsalaryempmodlog_del')")
    @SysLog("通过id删除薪资人员档案变更记录" )
    @DeleteMapping("/{id}" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tSalaryEmpModLogService.removeById(id));
    }

}
