package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSpecialDeducationSum;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSpecialDeducationSumService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


/**
 * @Author fxj
 * @Description
 * @Date 13:33 2022/8/6
 * @Param 
 * @return 
**/
@RestController
@AllArgsConstructor
@RequestMapping("/tspecialdeducationsum")
@Tag(name = "专项扣除信息")
public class TSpecialDeducationSumController {

	private final TSpecialDeducationSumService tSpecialDeducationSumService;

	/**
	 * 简单分页查询
	 *
	 * @param page                  分页对象
	 * @param tSpecialDeducationSum
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TSpecialDeducationSum>> getTSpecialDeducationSumPage(Page<TSpecialDeducationSum> page, TSpecialDeducationSum tSpecialDeducationSum) {
		page.addOrder(OrderItem.desc("CREATE_TIME"));
		return new R<>(tSpecialDeducationSumService.getTSpecialDeducationSumPage(page, tSpecialDeducationSum));
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "id查询")
	@GetMapping("/{id}")
	public R<TSpecialDeducationSum> getById(@PathVariable("id") String id) {
		return new R<>(tSpecialDeducationSumService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tSpecialDeducationSum
	 * @return R
	 */
	@Operation(description = "新增(wxhr:tspecialdeducationsum_add)")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tspecialdeducationsum_add')")
	public R<Boolean> save(@Valid @RequestBody TSpecialDeducationSum tSpecialDeducationSum) {
		return new R<>(tSpecialDeducationSumService.save(tSpecialDeducationSum));
	}

	/**
	 * 修改记录
	 *
	 * @param tSpecialDeducationSum
	 * @return R
	 */
	@Operation(description = "修改(wxhr:tspecialdeducationsum_edit)")
	@SysLog("修改")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tspecialdeducationsum_edit')")
	public R<Boolean> update(@RequestBody TSpecialDeducationSum tSpecialDeducationSum) {
		return new R<>(tSpecialDeducationSumService.updateById(tSpecialDeducationSum));
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "删除(wxhr:tspecialdeducationsum_del)")
	@SysLog("删除")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('wxhr:tspecialdeducationsum_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return new R<>(tSpecialDeducationSumService.removeById(id));
	}

	/**
	 * @param savList
	 * @Description: 保存专项
	 * @Author: hgw
	 * @Date: 2019/10/14 14:48
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "上传专项扣除")
	@SysLog("上传专项扣除")
	@PostMapping("/uploadSds")
	//@PreAuthorize("@pms.hasPermission('wxhr:salary_upload')")
	public R<List<ErrorMessage>> uploadSds(@RequestBody List<TSpecialDeducationSum> savList) {
		return tSpecialDeducationSumService.uploadSds(savList);
	}

	/**
	 * @Author fxj
	 * @Description
	 * @Date 14:31 2022/8/17
	 * @Param
	 * @return
	**/
	@Operation(description = "获取申报单位对应月份专项扣除条数")
	@GetMapping("/getCountOfDeclareTitle")
	public R<Long> uploadSds(String yearMonth, String declareTitle) {
		if (Common.isEmpty(yearMonth)) {
			SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
			yearMonth = df.format(new Date());
		}
		return R.ok(tSpecialDeducationSumService.count(Wrappers.<TSpecialDeducationSum>query().lambda()
				.eq(TSpecialDeducationSum::getDeclareTitle,declareTitle)
				.eq(TSpecialDeducationSum::getCreateMonth,yearMonth)));
	}
	/**
	 * @param declareTitle
	 * @Description: 删除当月全部-专项扣除汇总
	 * @Author: hgw
	 * @Date: 2020/4/1 14:47
	 * @return: java.lang.String
	 **/
	@Operation(description = "删除本月全部专项扣除")
	@SysLog("删除本月全部专项扣除")
	@PostMapping("/doDeleteTSumSpecialDeducationAll")
	public R<Boolean> doDeleteTSumSpecialDeducationAll(String yearMonth, String declareTitle) {
		if (Common.isEmpty(yearMonth)) {
			SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
			yearMonth = df.format(new Date());
		}
		if (Common.isEmpty(declareTitle)) {
			return R.failed("申报单位不可为空！");
		}
		int num = tSpecialDeducationSumService.deleteByUnitAndMonth(yearMonth, declareTitle);
		if (num == 0) {
			return R.failed("当前条件查询无数据，未删除");
		} else {
			return R.ok(null,"已删除" + num + "条数据");
		}
	}

	/**
	 * @param tSpecialDeducationSum
	 * @Description: 导出专项扣除
	 * @Author: hgw
	 * @Date: 2020-6-17 17:30:12
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "导出专项扣除")
	@SysLog("导出专项扣除")
	@GetMapping("/doExportSpecialDeducationSum")
	public R<List<TSpecialDeducationSum>> doExportSpecialDeducationSum(TSpecialDeducationSum tSpecialDeducationSum) {
		if (Common.isEmpty(tSpecialDeducationSum.getCreateMonth())) {
			String nowMonth = DateUtil.addMonth(0);  //本月
			tSpecialDeducationSum.setCreateMonth(nowMonth);
		}
		List<TSpecialDeducationSum> sPage = tSpecialDeducationSumService.getTSpecialDeducationSumList(tSpecialDeducationSum);
		return new R<>(sPage);
	}

}
