package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAuditRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 审批记录表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@Mapper
public interface TAuditRecordMapper extends BaseMapper<TAuditRecord> {
    /**
     * 审批记录表简单分页查询
     * @param tAuditRecord 审批记录表
     * @return
     */
    IPage<TAuditRecord> getTAuditRecordPage(Page<TAuditRecord> page, @Param("tAuditRecord") TAuditRecord tAuditRecord);

	/**
	 * 通过实体id和审核类型查询所有的审核记录
	 *
	 * @param domainId  实体id
	 * @param auditType 审核类型 0不购买商险审核
	 * @return List<TAuditRecord>
	 **/
	List<TAuditRecord> getAuditRecordList(@Param("domainId") String domainId, @Param("auditType") String auditType);
}
