package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchaseApply;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchaseApplySearchVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchaseApplyVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 含风险项目不购买申请表
 *
 * @author huych
 * @date 2025-01-10 11:24:38
 */
@Mapper
public interface TInsuranceUnpurchaseApplyMapper extends BaseMapper<TInsuranceUnpurchaseApply> {
    /**
     * 含风险项目不购买申请表简单分页查询
     * @param tInsuranceUnpurchaseApply 含风险项目不购买申请表
     * @return
     */
    IPage<TInsuranceUnpurchaseApply> getTInsuranceUnpurchaseApplyPage(Page<TInsuranceUnpurchaseApply> page
			, @Param("tInsuranceUnpurchaseApply") TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply);

	/**
	 * 含风险项目不购买申请表简单分页查询
	 * @param tInsuranceUnpurchaseApply 含风险项目不购买申请表
	 * @return
	 */
	long getTInsuranceUnpurchaseApplyExportCount(@Param("tInsuranceUnpurchaseApply") TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply);

	/**
	 * 含风险项目不购买申请表简单导出查询
	 * @param tInsuranceUnpurchaseApply 含风险项目不购买申请表
	 * @return
	 */
	List<TInsuranceUnpurchaseApplyVo> getTInsuranceUnpurchaseApplyExportList(@Param("tInsuranceUnpurchaseApply") TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply);

	String getMaxInusuranceCode();

	String getMaxInusuranceDetailCode();

	long selectSocialCount(@Param("deptNo") String deptNo,@Param("cardNo") String cardNo,@Param("id") String id);

	long selectArchCount(@Param("deptNo") String deptNo,@Param("cardNo") String cardNo,@Param("id") String id);

	/**
	 * 待审核分页查询
	 * @param page           分页信息
	 * @param tInsuranceUnpurchaseApply 不购买申请查询信息
	 * @param userId         登录用户id
	 * @return IPage
	 */
	IPage<TInsuranceUnpurchaseApply> getAuditPage(Page<TInsuranceUnpurchaseApply> page,
												  @Param("tInsuranceUnpurchaseApply") TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply,
												  @Param("userId") String userId);

	/**
	 * 已审核分页查询
	 * @param page           分页信息
	 * @param tInsuranceUnpurchaseApply 不购买申请查询信息
	 * @param userId         登录用户id
	 * @return IPage
	 */
	IPage<TInsuranceUnpurchaseApply> getHistoryHandlePage(Page<TInsuranceUnpurchaseApply> page,
														  @Param("tInsuranceUnpurchaseApply") TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply,
														  @Param("userId") String userId);

	/**
	 * 待审核数量
	 * @param userId         登录用户id
	 * @return IPage
	 */
	Integer getAuditCount(@Param("userId") String userId);

	/**
	 * 已审核数量
	 * @param userId         登录用户id
	 * @return IPage
	 */
	Integer getHistoryHandleCount(@Param("userId") String userId);

	/**
	 * 抄送分页查询
	 * @param page           分页信息
	 * @param tInsuranceUnpurchaseApply 不购买申请查询信息
	 * @param userId         登录用户id
	 * @return IPage
	 */
	IPage<TInsuranceUnpurchaseApply> getCopyPage(Page<TInsuranceUnpurchaseApply> page,
												 @Param("tInsuranceUnpurchaseApply") TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply,
												 @Param("userId") String userId);
}
