package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchasePersonSalary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 含风险项目不购买申请明细表-薪资关联表
 *
 * @author hgw
 * @date 2025-1-15 11:54:52
 */
@Mapper
public interface TInsuranceUnpurchasePersonSalaryMapper extends BaseMapper<TInsuranceUnpurchasePersonSalary> {
	/**
	 * 含风险项目不购买申请明细表简单分页查询-薪资关联
	 *
	 * @param tInsuranceUnpurchasePersonSalary 含风险项目不购买申请明细表-薪资关联
	 * @return
	 */
	IPage<TInsuranceUnpurchasePersonSalary> getTInsuranceUnpurchasePersonSalaryPage(Page<TInsuranceUnpurchasePersonSalary> page
			, @Param("tInsuranceUnpurchasePersonSalary") TInsuranceUnpurchasePersonSalary tInsuranceUnpurchasePersonSalary);

	// 查找薪资对用的人员表
	List<String> getParentIdBySalaryId(@Param("salaryId") String salaryId);

	// 删除关联项
	void deletePersonSalaryBySalaryId(@Param("salaryId") String salaryId);

	// 刷新次数
	void updatePersonSalaryNumByPersonIdList(@Param("idList") List<String> idList);

}
