/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount2022;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
/**
 * 工资报账主表2022
 *
 * @author hgw
 * @date 2022-08-05 11:40:15
 */
@Mapper
public interface TSalaryAccount2022Mapper extends BaseMapper<TSalaryAccount2022> {
    /**
     * 工资报账主表2022简单分页查询
     * @param tSalaryAccount2022 工资报账主表2022
     * @return
     */
    IPage<TSalaryAccount2022> getTSalaryAccount2022Page(Page<TSalaryAccount2022> page, @Param("tSalaryAccount2022") TSalaryAccount2022 tSalaryAccount2022);

	/**
	 * @param tableName
	 * @Description: 自动创建年度报账表
	 * @Author: hgw
	 * @Date: 2022/8/23 16:32
	 * @return: void
	 **/
	void createAccountYear(@Param("tableName") String tableName);

	int deleteSalaryAccountYearByMonth(@Param("tableName") String tableName, @Param("lastMonth") String lastMonth);

	int insertIntoSalaryAccountYear(@Param("tableName") String tableName, @Param("lastMonth") String lastMonth);

}
