package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAuditRecord;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TAuditRecordSearchVo;

import java.util.Map;

/**
 * 审批记录表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
public interface TAuditRecordService extends IService<TAuditRecord> {
    /**
     * 审批记录表简单分页查询
     * @param tApprovalRecord 审批记录表
     * @return
     */
    IPage<TAuditRecord> getTApprovalRecordPage(Page<TAuditRecord> page, TAuditRecordSearchVo tApprovalRecord);

	/**
	 * 通过实体id和审核类型查询所有的审核记录
	 * @param domainId  实体id
	 * @param auditType 审核类型 0不购买商险审核
	 * @return R<Map<String, Object>> key=auditInfo表示审批记录列表
	 **/
	R<Map<String, Object>> getAuditInfoByDomainIdAndAuditType(String domainId, String auditType);
}
