/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 户与失败原因配置多对多关系表
 * @author hgw
 * @date 2025-9-5 16:33:22
 */
@Data
@TableName("sys_house_hold_info_fail_res")
@Schema(description = "户与失败原因配置多对多关系表")
public class SysHouseHoldInfoFailRes {

	// 户ID
	private String id;
	// 失败原因ID
	private String failId;
	// 重新办理动作 1 继续办理 2 中止办理 3 人工办理
	private String replay;

	// 查询 关键字
	@TableField(exist = false)
	private String reasonKey;

}
