/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
@Data
@TableName("t_auto_payment_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "自动化实缴记录表")
public class TAutoPaymentInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 生成月
	 */
	@ExcelAttribute(name = "生成月", maxLength = 6)
	@Length(max = 1, message = "生成月不能超过6个字符")
	@ExcelProperty("生成月")
	@Schema(description = "生成月")
	private String createMonth;
	/**
	 * 数据整合之日常申报：0未整合1整合中2已整合3整合失败
	 */
	@ExcelAttribute(name = "数据整合之日常申报", maxLength = 1)
	@Length(max = 1, message = "数据整合之日常申报不能超过1个字符")
	@ExcelProperty("数据整合之日常申报")
	@Schema(description = "数据整合之日常申报：0未整合1整合中2已整合3整合失败")
	private String dataOneFlag;
	/**
	 * 数据整合之人员缴费明细：0未整合1整合中2已整合3整合失败
	 */
	@ExcelAttribute(name = "数据整合之人员缴费明细", maxLength = 1)
	@Length(max = 1, message = "数据整合之人员缴费明细不能超过1个字符")
	@ExcelProperty("数据整合之人员缴费明细")
	@Schema(description = "数据整合之人员缴费明细：0未整合1整合中2已整合3整合失败")
	private String dataTwoFlag;
	/**
	 * 数据整合之单位缴费明细：0未整合1整合中2已整合3整合失败
	 */
	@ExcelAttribute(name = "数据整合之单位缴费明细", maxLength = 1)
	@Length(max = 1, message = "数据整合之单位缴费明细不能超过1个字符")
	@ExcelProperty("数据整合之单位缴费明细")
	@Schema(description = "数据整合之单位缴费明细：0未整合1整合中2已整合3整合失败")
	private String dataThreeFlag;
	/**
	 * 数据整合之日常申报的备注
	 */
	@ExcelAttribute(name = "数据整合之日常申报的备注", maxLength = 100)
	@Length(max = 100, message = "数据整合之日常申报的备注不能超过100个字符")
	@ExcelProperty("数据整合之日常申报的备注")
	@Schema(description = "数据整合之日常申报的备注")
	private String dataOneRemark;
	/**
	 * 数据整合之人员缴费明细的备注
	 */
	@ExcelAttribute(name = "数据整合之人员缴费明细的备注", maxLength = 100)
	@Length(max = 100, message = "数据整合之人员缴费明细的备注不能超过100个字符")
	@ExcelProperty("数据整合之人员缴费明细的备注")
	@Schema(description = "数据整合之人员缴费明细的备注")
	private String dataTwoRemark;
	/**
	 * 数据整合之单位缴费明细的备注
	 */
	@ExcelAttribute(name = "数据整合之单位缴费明细的备注", maxLength = 100)
	@Length(max = 100, message = "数据整合之单位缴费明细的备注不能超过100个字符")
	@ExcelProperty("数据整合之单位缴费明细的备注")
	@Schema(description = "数据整合之单位缴费明细的备注")
	private String dataThreeRemark;
	/**
	 * 系统复核：0未复核1复核中2复核成功3复核失败
	 */
	@ExcelAttribute(name = "系统复核", maxLength = 1)
	@Length(max = 1, message = "系统复核不能超过1个字符")
	@ExcelProperty("系统复核：0未复核1复核中2复核成功3复核失败")
	@Schema(description = "系统复核：0未复核1复核中2复核成功3复核失败")
	private String systemReviewFlag;
	/**
	 * 重新复核状态 0未复核1复核中2复核成功3复核失败
	 */
	@ExcelAttribute(name = "重新复核状态", maxLength = 1)
	@Length(max = 1, message = "重新复核状态不能超过1个字符")
	@ExcelProperty("重新复核状态 0未复核1复核中2复核成功3复核失败")
	@Schema(description = "重新复核状态 0未复核1复核中2复核成功3复核失败")
	private String repeatReviewFlag;

	/**
	 * 资源路径
	 */
	@ExcelAttribute(name = "资源路径", maxLength = 200)
	@Length(max = 200, message = "资源路径不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源路径")
	private String attaSrc;
	/**
	 * 资源地址
	 */
	@ExcelAttribute(name = "资源地址", maxLength = 100)
	@Length(max = 100, message = "资源地址不能超过100个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源地址")
	private String attaUrl;
	/**
	 * 原表资源地址1
	 */
	@ExcelAttribute(name = "原表资源地址1", maxLength = 200)
	@Length(max = 200, message = "原表资源地址1不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表资源地址1")
	private String attaUrlOne;
	/**
	 * 原表资源地址2
	 */
	@ExcelAttribute(name = "原表资源地址2", maxLength = 200)
	@Length(max = 200, message = "原表资源地址2不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表资源地址2")
	private String attaUrlTwo;
	/**
	 * 原表资源地址3
	 */
	@ExcelAttribute(name = "原表资源地址3", maxLength = 200)
	@Length(max = 200, message = "原表资源地址3不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表资源地址3")
	private String attaUrlThree;
	/**
	 * 原表资源地址4
	 */
	@ExcelAttribute(name = "原表资源地址4", maxLength = 200)
	@Length(max = 200, message = "原表资源地址4不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表资源地址4")
	private String attaUrlFour;

}
