/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 社保导出花名册记录表
 *
 * @author hgw
 * @date 2025-06-16 14:29:13
 */
@Data
@TableName("t_dispatch_export_log")
@Schema(description = "社保导出花名册记录表")
public class TDispatchExportLog {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 派单ID
	 */
	@ExcelAttribute(name = "派单ID", isNotEmpty = true, errorInfo = "派单ID不能为空", maxLength = 32)
	@NotBlank(message = "派单ID不能为空")
	@Length(max = 32, message = "派单ID不能超过32个字符")
	@ExcelProperty("派单ID")
	@Schema(description = "派单ID")
	private String dispatchId;
	/**
	 * 用户ID
	 */
	@ExcelAttribute(name = "用户ID", isNotEmpty = true, errorInfo = "用户ID不能为空", maxLength = 32)
	@NotBlank(message = "用户ID不能为空")
	@Length(max = 32, message = "用户ID不能超过32个字符")
	@ExcelProperty("用户ID")
	@Schema(description = "用户ID")
	private String userId;
	/**
	 * 用户名
	 */
	@ExcelAttribute(name = "用户名", isNotEmpty = true, errorInfo = "用户名不能为空", maxLength = 32)
	@NotBlank(message = "用户名不能为空")
	@Length(max = 32, message = "用户名不能超过32个字符")
	@ExcelProperty("用户名")
	@Schema(description = "用户名")
	private String userName;
	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	@ColumnWidth(18)
	private LocalDateTime createTime;
	
	/**
	 * @Description: 编号_给前端用的
	 * @Author: hgw
	 * @Date: 2025/6/16 15:27
	 * @return: 
	 **/
	@TableField(exist = false)
	@Schema(description = "编号")
	private long number;

}
