/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.social.vo.SocialImportHandleVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
@TableName("t_dispatch_info" )
@EqualsAndHashCode(callSuper = true)
@Schema(description = "派单信息记录表" )
public class TDispatchInfo extends BaseEntity {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("ID" )
	private String id;

	/**
	 * 派单申请编码
	 */
	@ExcelAttribute(name = "派单申请编码", maxLength = 30)
	@Schema(description = "派单申请编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单申请编码" )
	private String dispatchCode;

	/**
	 * 重新派单号
	 */
	@ExcelAttribute(name = "重新派单号", maxLength = 30)
	@Schema(description = "重新派单号" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("重新派单号" )
	private String againDispatchCode;

	/**
	 * 员工ID
	 */
	@NotBlank(message = "员工ID不能为空" )
	@Length(max = 32, message = "员工ID 不能超过32个字符" )
	@ExcelAttribute(name = "员工ID", isNotEmpty = true, errorInfo = "员工ID不能为空", maxLength = 32)
	@Schema(description = "员工ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工ID" )
	private String empId;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 员工编码
	 */
	@Length(max = 30, message = "员工编码 不能超过30个字符" )
	@ExcelAttribute(name = "员工编码", maxLength = 30)
	@Schema(description = "员工编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码" )
	private String empNo;
	/**
	 * 员工身份证
	 */
	@Length(max = 20, message = "员工身份证 不能超过20个字符" )
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工身份证" )
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@Length(max = 32, message = "员工类型 不能超过32个字符" )
	@ExcelAttribute(name = "员工类型", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型" )
	private String empType;
	/**
	 * 员工电话  （手机号码）
	 */
	@Length(max = 32, message = "手机号码 不能超过32个字符" )
	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Schema(description = "手机号码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码" )
	private String empMobile;
	/**
	 * 民族
	 */
	@Length(max = 32, message = "民族 不能超过32个字符" )
	@ExcelAttribute(name = "民族", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATIONAL)
	@Schema(description = "民族" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("民族" )
	private String empNational;
	/**
	 * 0未提交1待审核2审核通过3审核不通过4办理完成
	 */
	@NotBlank(message = "0未提交1待审核2审核通过3审核不通过4办理完成不能为空5待SSC审核" )
	@Length(max = 1, message = "0未提交1待审核2审核通过3审核不通过4办理完成5待SSC审核 不能超过1个字符" )
	@ExcelAttribute(name = "0未提交1待审核2审核通过3审核不通过4办理完成5待SSC审核", isNotEmpty = true, errorInfo = "0未提交1待审核2审核通过3审核不通过4办理完成5待SSC审核不能为空", maxLength = 1)
	@Schema(description = "0未提交1待审核2审核通过3审核不通过4办理完成5待SSC审核" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0未提交1待审核2审核通过3审核不通过4办理完成5待SSC审核" )
	private String status;
	/**
	 * 0派增1派减
	 */
	@NotBlank(message = "0派增1派减不能为空" )
	@Length(max = 1, message = "0派增1派减 不能超过1个字符" )
	@ExcelAttribute(name = "0派增1派减", isNotEmpty = true, errorInfo = "0派增1派减不能为空", maxLength = 1)
	@Schema(description = "0派增1派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0派增1派减" )
	private String type;
	/**
	 * 社保ID
	 */
	@Length(max = 32, message = "社保ID 不能超过32个字符" )
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Schema(description = "社保ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保ID" )
	private String socialId;
	/**
	 * 公积金ID
	 */
	@Length(max = 32, message = "公积金ID 不能超过32个字符" )
	@ExcelAttribute(name = "公积金ID", maxLength = 32)
	@Schema(description = "公积金ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金ID" )
	private String fundId;
	/**
	 * 0社保1公积金
	 */
	@Length(max = 1, message = "0社保1公积金 不能超过1个字符" )
	@ExcelAttribute(name = "0社保1公积金", maxLength = 1)
	@Schema(description = "0社保1公积金" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0社保1公积金" )
	private String typeSub;
	/**
	 * 流程实例ID
	 */
	@Length(max = 20, message = "流程实例ID 不能超过20个字符" )
	@ExcelAttribute(name = "流程实例ID", maxLength = 20)
	@Schema(description = "流程实例ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("流程实例ID" )
	private String processInstId;
	/**
	 * 项目
	 */
	@Length(max = 32, message = "项目 不能超过32个字符" )
	@ExcelAttribute(name = "项目", maxLength = 32)
	@Schema(description = "项目" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目" )
	private String settleDomain;

	/**
	 * 0未删除1删除
	 */
	@Length(max = 1, message = "0未删除1删除 不能超过1个字符" )
	@ExcelAttribute(name = "0未删除1删除", maxLength = 1)
	@Schema(description = "0未删除1删除" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0未删除1删除" )
	private String deleteFlag;
	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;
	/**
	 * 公积金停缴日期
	 */
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金停缴日期" )
	private Date fundReduceDate;
	/**
	 * 离职日期
	 */
	@ExcelAttribute(name = "离职日期", isDate = true)
	@Schema(description = "离职日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("离职日期" )
	private Date leaveDate;
	/**
	 * 减少原因
	 */
	@Length(max = 32, message = "减少原因 不能超过32个字符" )
	@ExcelAttribute(name = "减少原因", maxLength = 32)
	@Schema(description = "减少原因" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减少原因" )
	private String reduceReason;
	/**
	 * 减少备注
	 */
	@Length(max = 200, message = "减少备注 不能超过200个字符" )
	@ExcelAttribute(name = "减少备注", maxLength = 200)
	@Schema(description = "减少备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减少备注" )
	private String reduceRemark;
	/**
	 * 所属单位
	 */
	@Length(max = 32, message = "所属单位 不能超过32个字符" )
	@ExcelAttribute(name = "所属单位", maxLength = 32)
	@Schema(description = "所属单位" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属单位" )
	private String belongUnit;
	/**
	 * 当前操作人
	 */
	@Length(max = 32, message = "当前操作人 不能超过32个字符" )
	@ExcelAttribute(name = "当前操作人", maxLength = 32)
	@Schema(description = "当前操作人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("当前操作人" )
	private String currentOperator;
	/**
	 * 数据迁移使用
	 */
	@Length(max = 32, message = "数据迁移使用 不能超过32个字符" )
	@ExcelAttribute(name = "数据迁移使用", maxLength = 32)
	@Schema(description = "数据迁移使用" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据迁移使用" )
	private String dispatchIdBak;
	/**
	 * 合同起始时间
	 */
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始时间" )
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同到期时间" )
	private Date contractEnd;
	/**
	 * 合同年限
	 */
	@ExcelAttribute(name = "合同年限" )
	@Schema(description = "合同年限" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同年限" )
	private String contractTerm;

	/**
	 * 合同ID ---- 派增持有
	 */
	@ExcelAttribute(name = "合同ID" )
	@Schema(description = "合同ID---- 派增持有" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同ID" )
	private String contractId;
	/**
	 * 户口性质
	 */
	@Length(max = 32, message = "户口性质 不能超过32个字符" )
	@ExcelAttribute(name = "户口性质", maxLength = 32)
	@Schema(description = "户口性质" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("户口性质" )
	private String empRegisType;

	/**
	 * 档案所在地
	 */
	@Length(max = 50, message = "档案所在地 不能超过50个字符" )
	@ExcelAttribute(name = "档案所在地", maxLength = 50)
	@Schema(description = "档案所在地" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案所在地" )
	private String fileAddr;
	/**
	 * 就职岗位
	 */
	@Length(max = 30, message = "就职岗位 不能超过30个字符" )
	@ExcelAttribute(name = "就职岗位", maxLength = 30)
	@Schema(description = "就职岗位" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("就职岗位" )
	private String post;
	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String trustRemark;
	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省" )
	@Schema(description = "档案-省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-省" )
	private Integer fileProvince;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市" )
	@Schema(description = "档案-市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-市" )
	private Integer fileCity;
	/**
	 * 档案-县
	 */
	@ExcelAttribute(name = "档案-县" )
	@Schema(description = "档案-县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-县" )
	private Integer fileTown;
	/**
	 * 合同类型
	 */
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 32, message = "合同类型不能超过32个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;

	/**
	 * 业务细分 personnel_type_sub
	 */
	@ExcelAttribute(name = "业务细分", maxLength = 32)
	@Schema(description = "业务细分", name = "contractSubName")
	private String contractSubName;

	/**
	 * 签订期限e
	 * 0        已完成一定工作任务为期限
	 * 1        固定期限
	 * 2        无固定期限
	 */
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;


	/**
	 * 社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败）  3 部分办理成功 4 办理中
	 *
	 * 20230131 MVP1.5.0版本新增拆分派减逻辑：
	 * 1、派减状态：增加：办理中（派减存在未处理完的事项时，状态为“办理中”）、部分办理失败状态（派减全部事项处理完毕，存在办理失败的事项）——同派增状态保持一致
	 * 2、预估数据逻辑：仅当派减办理成功状态时，才会不生成次月预估费用；未办理、办理中、部分办理失败都是全额生成社保预估费用；
	 * 3、档案查询中的状态沿用派增的处理中和部分购买；
	 * 4、新增三种无需审核的合同需测试验证；
	 * 5、派减全部减掉之后，在社保公积金查询处，将“停缴日期”调整为“最迟停缴日期”，取最后一次的办理成功时客服导表中填写的停缴日期，精确到日；
	 * 6、社保公积金查询、派单查询、档案查询-社保详情中，针对派减的在下方明细处增加“停缴日期”列，显示到“年月日”；
	 * 7、流程进展明细中，将分项减员的操作记录按照操作人、操作时间、派减项进行记录；
	 * 8、社保公积金查询处，查询条件：社保状态-增加“派减-办理中”、”派减-部分办理失败“，支持查询、列表正常显示、及导出；
	 * 9、批量办理界面呈现效果按照芳利拍照的效果呈现；
	 * 10、针对派单-部分派减的，需判断是否有流程中的数据，如果有，不允许再次发起；仅当派单项全部为完结状态，并且有未派减项，才允许发起派减；
	 * 11、增加查询项-”派单项“下拉多选——养老、工伤、失业、医保、生育、大病；搜索项只要有重叠的都可以被检索到；
	 */
	@Length(max = 1, message = "社保办理状态  不能超过1个字符" )
	@ExcelAttribute(name = "社保办理状态", maxLength = 1)
	@Schema(description = "社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3 部分办理成功 4 办理中" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理状态" )
	private String socialHandleStatus;
	/**
	 * 公积金办理状态:0 未办理 1办理成功 2 办理失败
	 */
	@Length(max = 1, message = "公积金办理状态 不能超过1个字符" )
	@ExcelAttribute(name = "公积金办理状态", maxLength = 1)
	@Schema(description = "公积金办理状态:0 未办理 1办理成功 2 办理失败 " )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理状态" )
	private String fundHandleStatus;
	/**
	 * 当前流程环节的处理意见
	 */
	@Length(max = 200, message = "当前流程环节的处理意见 不能超过200个字符" )
	@ExcelAttribute(name = "当前流程环节的处理意见", maxLength = 200)
	@Schema(description = "当前流程环节的处理意见" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("当前流程环节的处理意见" )
	private String handleRemark;
	/**
	 * 审核意见
	 */
	@Length(max = 255, message = "审核意见 不能超过255个字符" )
	@ExcelAttribute(name = "审核意见", maxLength = 255)
	@Schema(description = "审核意见" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核意见" )
	private String auditRemark;

	/**
	 * 0 是 1 否
	 */
	@Length(max = 1, message = "是否同步终止合同、减项、减档不能超过1个字符")
	@ExcelAttribute(name = "是否同步终止合同、减项、减档", maxLength = 1)
	@Schema(description = "是否同步终止合同、减项、减档", name = "changeContractAndEmployee")
	private String changeContractAndEmployee;

	/**
	 * 公积金办理备注
	 */
	@Length(max = 255, message = "公积金办理备注 不能超过255个字符" )
	@ExcelAttribute(name = "公积金办理备注", maxLength = 255)
	@Schema(description = "公积金办理备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理备注" )
	private String fundHandleRemark;
	/**
	 * 办理备注
	 */
	@Length(max = 255, message = "办理备注 不能超过255个字符" )
	@ExcelAttribute(name = "办理备注", maxLength = 255)
	@Schema(description = "办理备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理备注" )
	private String socialHandleRemark;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-省" )
	private String socialProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 11, message = "缴纳地-市 不能超过11个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 11)
	@Schema(description = "缴纳地-市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-市" )
	private String socialCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-县" )
	private String socialTown;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-省" )
	private String fundProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-市" )
	private String fundCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-县" )
	private String fundTown;
	/**
	 * 审核人
	 */
	@Length(max = 32, message = "审核人 不能超过32个字符" )
	@ExcelAttribute(name = "审核人", maxLength = 32)
	@Schema(description = "审核人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人" )
	private String auditUser;

	/**
	 * 审核人姓名
	 */
	@Length(max = 32, message = "审核人姓名 不能超过32个字符" )
	@Schema(description = "审核人姓名" )
	@ExcelIgnore
	private String auditUserName;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@Schema(description = "审核时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核时间" )
	private Date auditTime;

	/**
	 * 工时制：1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 1, message = "工时制 不能超过1个字符" )
	@ExcelAttribute(name = "工时制", maxLength = 1, readConverterExp = "1=标准工时,2=综合工时,3=不定时工时制")
	@Schema(description = "工时制：1标准工时 2 综合工时 3不定时工时制" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工时制" )
	private String workingHours;
	/**
	 * 申请人所在部门
	 */
	@Length(max = 50, message = "申请人所在部门 不能超过50个字符" )
	@ExcelAttribute(name = "申请人所在部门", maxLength = 50)
	@Schema(description = "申请人所在部门" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请人所在部门" )
	private String organName;
	/**
	 * 派单项：如 养老、公积金
	 */
	@Length(max = 50, message = "派单项：如 养老、公积金 不能超过50个字符" )
	@ExcelAttribute(name = "派单项：如 养老、公积金", maxLength = 50)
	@Schema(description = "派单项：如 养老、公积金" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单项：如 养老、公积金" )
	private String dispatchItem;
	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50个字符" )
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称" )
	private String settleDomainName;

	/**
	 * 项目编码
	 */
	@Length(max = 50, message = "项目编码 不能超过50个字符" )
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码" )
	private String settleDomainCode;

	/**
	 * 单位名称
	 */
	@Length(max = 50, message = "单位名称 不能超过50个字符" )
	@ExcelAttribute(name = "单位名称", maxLength = 50)
	@Schema(description = "单位名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位名称" )
	private String belongUnitName;


	/**
	 * 学历
	 */
	@ExcelAttribute(name = "学历", maxLength = 32)
	@Schema(description = "学历", name = "contractName")
	private String educationName;

	/**
	 * 学校
	 */
	@ExcelAttribute(name = "学校",isNotEmpty = false)
	@Length(max = 50, message = "学校不能超过50个字符")
	@Schema(description = "学校：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学校")
	private String schoolName;

	/**
	 * 专业
	 */
	@ExcelAttribute(name = "专业",isNotEmpty = false)
	@Length(max = 50, message = "学校不能超过50个字符")
	@Schema(description = "专业：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="专业")
	private String major;

	/**
	 * 毕业时间
	 */
	@ExcelAttribute(name = "毕业时间", isDate = true)
	@Schema(description = "毕业时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("毕业时间" )
	private Date graduationTime;

	/**
	 * 首次至缴纳地时间
	 */
	@ExcelAttribute(name = "首次至缴纳地时间",isNotEmpty = false, isDate = true)
	@Length(max = 50, message = "学校不能超过50个字符")
	@Schema(description = "首次至缴纳地时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="首次至缴纳地时间")
	private Date firstPayTime;

	/**
	 * 试用期（单位月）
	 */
	@Length(max = 2, message = "试用期 不能超过2 个字符" )
	@ExcelAttribute(name = "试用期", maxLength = 32)
	@Schema(description = "试用期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("试用期" )
	private String tryPeriod;

	/**
	 * 身份证省
	 */
	@ExcelAttribute(name = "身份证省" ,isArea = true)
	@Schema(description = "身份证省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证省" )
	private String idCardProvince;
	/**
	 * 身份证市
	 */
	@ExcelAttribute(name = "身份证市" ,isArea = true,parentField = "idCardProvince")
	@Schema(description = "身份证市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证市" )
	private String idCardCity;
	/**
	 * 身份证县
	 */
	@ExcelAttribute(name = "身份证县",isArea = true,parentField = "idCardCity")
	@Schema(description = "身份证县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证县" )
	private String idCardTown;

	/**
	 * 身份证所在地
	 */
	@ExcelAttribute(name = "身份证所在地")
	@Schema(description = "身份证所在地" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证所在地" )
	private String idCardAddress;

	/**
	 * 申请编码
	 */
	@ExcelAttribute(name = "申请编码")
	@Schema(description = "申请编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请编码" )
	private String applyNo;


	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称", maxLength = 50)
	@Schema(description = "社保户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户名称" )
	private String socialHouseholdName;

	/**
	 * 公积金户名称
	 */
	@ExcelAttribute(name = "公积金户名称", maxLength = 50)
	@Schema(description = "公积金户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户名称" )
	private String providentHouseholdName;

	/**
	 * 首次购买时间（第一派单月份）
	 */
	@ExcelAttribute(name = "首次购买时间（第一派单月份）", isDate = true)
	@Schema(description = "首次购买时间（第一派单月份）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("首次购买时间（第一派单月份）" )
	private Date firstBuyMonthSocial;

	/**
	 * 订单ID
	 */
	@ExcelAttribute(name = "订单ID")
	@Schema(description = "订单ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("订单ID" )
	private String orderId;

	/**
	 * 原派单ID
	 * 2023-4-11 14:37:17
	 * hgw增加
	 */
	@TableField(exist = false)
	private String pid;

	/**
	 * @Author fxj
	 * @Description 社保是否已导出
	 * @Date 15:32 2023/5/9
	 * @Param
	 * @return
	**/
	@ExcelAttribute(name = "社保是否已导出", maxLength = 1)
	@Schema(description = "社保是否已导出：0否、1是" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保是否已导出" )
	private String exportSocialFlag;

	/**
	 * @Author fxj
	 * @Description 公積金是否已导出
	 * @Date 15:32 2023/5/9
	 * @Param
	 * @return
	 **/
	@ExcelAttribute(name = "公积金是否已导出", maxLength = 1)
	@Schema(description = "公积金是否已导出：0否、1是" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金是否已导出" )
	private String exportFundFlag;

	/**
	 * @Description: SSC 审核，不审核自己创建的
	 * @Author: hgw
	 * @Date: 2023/5/18 16:18
	 * @return:
	 **/
	@TableField(exist = false)
	private String noCreateUser;


	@TableField(exist = false)
	private SocialImportHandleVo excel;

	@TableField(exist = false)
	private String handlerRemaek;

	@TableField(exist = false)
	private String socialFailureType;

	@ExcelAttribute(name = "contactAddress")
	@Schema(description = "通信地址" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址" )
	private String contactAddress;


	/**
	 * @Author fxj
	 * @Description 社保自动化标识 0 是  1  否
	 * @Date 15:32 2023/5/9
	 * @Param
	 * @return
	 **/
	@ExcelAttribute(name = "社保自动化标识", maxLength = 1)
	@Schema(description = "社保自动化标识 0 是  1  否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保自动化标识" )
	private String autoFlag;

	/**
	 * 是否单个接口 0否1是（税友接口走单个还是批量，审核是否立即推送税友）
	 */
	@ExcelAttribute(name = "是否单个接口" )
	@Schema(description ="是否单个接口")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否单个接口")
	private String isSingle;

	/**
	 * 是否自动生成解除劳动合同书 0否1是（是的话，走单个推送，因为税友的减员接口没有批量附件的字段）
	 */
	@ExcelAttribute(name = "是否自动生成解除劳动合同书" )
	@Schema(description ="是否自动生成解除劳动合同书")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否自动生成解除劳动合同书 0否1是")
	private String isAutoLeaveDoc;

	/**
	 * 医保自动化（自动化配置状态） 0 启用 1 禁用   -MVP1.7.15新增医保自动化
	 */
	@Schema(description ="医保自动化")
	private String autoFlagYsd;

	/**
	 * 医保推送类型 0否1是 MVP1.7.15 新增医保推送类型 0批量 1单个
	 */
	@ExcelAttribute(name = "医保推送类型" )
	@Schema(description ="医保推送类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保推送类型")
	private String isSingleYsd;

	/**
	 * 社保是否自动生成花名册 0否1是
	 */
	@ExcelAttribute(name = "社保是否自动生成花名册" )
	@Schema(description ="社保是否自动生成花名册 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保是否自动生成花名册")
	private String rosterAutoFlagYgs;

	/**
	 * 医保是否自动生成花名册 0否1是
	 */
	@ExcelAttribute(name = "医保是否自动生成花名册" )
	@Schema(description ="医保是否自动生成花名册 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保是否自动生成花名册")
	private String rosterAutoFlagYsd;

	/**
	 * 社保仅补缴生成材料 0否1是
	 */
	@ExcelAttribute(name = "社保仅补缴生成材料" )
	@Schema(description ="社保仅补缴生成材料 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保仅补缴生成材料")
	private String dataFlagYgs;

	/**
	 * 医保仅补缴生成材料 0否1是
	 */
	@ExcelAttribute(name = "医保仅补缴生成材料" )
	@Schema(description ="医保仅补缴生成材料 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保仅补缴生成材料")
	private String dataFlagYsd;

	@Schema(description ="社保待购买id")
	@TableField(exist = false)
	private String preId;

}
