/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * EKP费用划转，改变缴费库、预估库、收入、收入明细、商险明细（订单表没有项目信息，不划转）
 *
 * @author hgw
 * @date 2022-11-17 15:58:59
 */
@Data
@TableName("t_ekp_change_dept_log")
@Schema(description = "EKP费用划转，改变缴费库、预估库、收入、收入明细、商险明细（订单表没有项目信息，不划转）")
public class TEkpChangeDeptLog {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 创建人-EKP传过来的
	 */
	@ExcelAttribute(name = "创建人-EKP传过来的", maxLength = 50)
	@Length(max = 50, message = "创建人-EKP传过来的不能超过50个字符")
	@ExcelProperty("创建人-EKP传过来的")
	@Schema(description = "创建人-EKP传过来的")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private Date createTime;
	/**
	 * 老项目名称
	 */
	@ExcelAttribute(name = "老项目名称", maxLength = 50)
	@Length(max = 50, message = "老项目名称不能超过50个字符")
	@ExcelProperty("老项目名称")
	@Schema(description = "老项目名称")
	private String preDeptName;
	/**
	 * 老项目编码
	 */
	@ExcelAttribute(name = "老项目编码", maxLength = 32)
	@Length(max = 32, message = "老项目编码不能超过32个字符")
	@ExcelProperty("老项目编码")
	@Schema(description = "老项目编码")
	private String preDeptNo;
	/**
	 * 新项目名称
	 */
	@ExcelAttribute(name = "新项目名称", maxLength = 50)
	@Length(max = 50, message = "新项目名称不能超过50个字符")
	@ExcelProperty("新项目名称")
	@Schema(description = "新项目名称")
	private String newDeptName;
	/**
	 * 新项目编码
	 */
	@ExcelAttribute(name = "新项目编码", maxLength = 32)
	@Length(max = 32, message = "新项目编码不能超过32个字符")
	@ExcelProperty("新项目编码")
	@Schema(description = "新项目编码")
	private String newDeptNo;
	/**
	 * 划转类型：类型1;类型2;类型3
	 */
	@ExcelAttribute(name = "划转类型：类型1;类型2;类型3", maxLength = 32)
	@Length(max = 32, message = "划转类型：类型1;类型2;类型3不能超过32个字符")
	@ExcelProperty("划转类型：类型1;类型2;类型3")
	@Schema(description = "划转类型：类型1;类型2;类型3")
	private String transferType;
	/**
	 * 缴费库预估库id(社保)
	 */
	@ExcelAttribute(name = "缴费库预估库id(社保)", maxLength = 2000)
	@Length(max = 2000, message = "缴费库预估库id(社保)不能超过2000个字符")
	@ExcelProperty("缴费库预估库id(社保)")
	@Schema(description = "缴费库预估库id(社保)")
	private String socialId;
	/**
	 * 缴费库预估库id(公积金)
	 */
	@ExcelAttribute(name = "缴费库预估库id(公积金)", maxLength = 2000)
	@Length(max = 2000, message = "缴费库预估库id(公积金)不能超过2000个字符")
	@ExcelProperty("缴费库预估库id(公积金)")
	@Schema(description = "缴费库预估库id(公积金)")
	private String fundId;
	/**
	 * 收入id(管理费)
	 */
	@ExcelAttribute(name = "收入id(管理费)", maxLength = 2000)
	@Length(max = 2000, message = "收入id(管理费)不能超过2000个字符")
	@ExcelProperty("收入id(管理费)")
	@Schema(description = "收入id(管理费)")
	private String manageId;
	/**
	 * 收入id(风险金)
	 */
	@ExcelAttribute(name = "收入id(风险金)", maxLength = 2000)
	@Length(max = 2000, message = "收入id(风险金)不能超过2000个字符")
	@ExcelProperty("收入id(风险金)")
	@Schema(description = "收入id(风险金)")
	private String riskId;
	/**
	 * 商险id
	 */
	@ExcelAttribute(name = "商险id", maxLength = 2000)
	@Length(max = 2000, message = "商险id不能超过2000个字符")
	@ExcelProperty("商险id")
	@Schema(description = "商险id")
	private String insuranceId;

}
