/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 税友推送和拉取的日志表，用于10分钟只能推拉一次
 *
 * @author hgw
 * @date 2025-03-18 15:43:40
 */
@Data
@TableName("t_social_freind_push_and_get")
@Schema(description = "税友推送和拉取的日志表，用于10分钟只能推拉一次")
public class TSocialFreindPushAndGet {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 类型：1推送；2拉取
	 */
	@ExcelAttribute(name = "类型：1推送；2拉取", isNotEmpty = true, errorInfo = "类型：1推送；2拉取不能为空")
	@NotBlank(message = "类型：1推送；2拉取不能为空")
	@ExcelProperty("类型：1推送；2拉取")
	@Schema(description = "类型：1推送；2拉取")
	private Integer type;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isNotEmpty = true, errorInfo = "创建时间不能为空", isDate = true)
	@NotBlank(message = "创建时间不能为空")
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;
	/**
	 * 创建人姓名
	 */
	@ExcelAttribute(name = "创建人姓名", isNotEmpty = true, errorInfo = "创建人姓名不能为空", maxLength = 50)
	@NotBlank(message = "创建人姓名不能为空")
	@Length(max = 50, message = "创建人姓名不能超过50个字符")
	@ExcelProperty("创建人姓名")
	@Schema(description = "创建人姓名")
	private String createUserName;

}
