/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 社保公积金调基历史记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
@TableName("t_social_fund_history" )
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保公积金调基历史记录表" )
public class TSocialFundHistory extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键" )
	private String id;
	/**
	 * name
	 */
	@Length(max = 20, message = "员工姓名 不能超过20个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Schema(description = "员工姓名" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * idCard
	 */
	@Length(max = 20, message = "身份证号 不能超过20个字符" )
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号" )
	private String empIdcard;
	/**
	 * employeeId
	 */
	@Length(max = 32, message = "员工id 不能超过32个字符" )
	@ExcelAttribute(name = "员工id", maxLength = 32)
	@Schema(description = "员工id" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工id" )
	private String empId;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数" )
	@Schema(description = "单位养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数" )
	private BigDecimal unitPensionCardinal;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数" )
	@Schema(description = "单位医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数" )
	private BigDecimal unitMedicalCardinal;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数" )
	@Schema(description = "单位失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数" )
	private BigDecimal unitUnemploymentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数" )
	@Schema(description = "单位生育基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数" )
	private BigDecimal unitBirthCardinal;
	/**
	 * 单位大病基数
	 */
	@ExcelAttribute(name = "单位大病基数" )
	@Schema(description = "单位大病基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病基数" )
	private BigDecimal unitBigailmentCardinal;

	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例" )
	@Schema(description = "单位养老比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例" )
	private BigDecimal unitPersionPro;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额" )
	@Schema(description = "单位养老金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老金额" )
	private BigDecimal unitPersionMoney;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例" )
	@Schema(description = "单位医疗比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例" )
	private BigDecimal unitMedicalPro;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额" )
	@Schema(description = "单位医疗金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗金额" )
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例" )
	@Schema(description = "单位失业比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例" )
	private BigDecimal unitUnemploymentPro;
	/**
	 * 单位失业金额
	 */
	@ExcelAttribute(name = "单位失业金额" )
	@Schema(description = "单位失业金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业金额" )
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例" )
	@Schema(description = "单位工伤比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例" )
	private BigDecimal unitInjuryPro;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额" )
	@Schema(description = "单位工伤金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤金额" )
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例" )
	@Schema(description = "单位生育比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例" )
	private BigDecimal unitBirthPro;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额" )
	@Schema(description = "单位生育金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育金额" )
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例" )
	@Schema(description = "单位大病比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例" )
	private BigDecimal unitBigailmentPro;
	/**
	 * 单位大病救助金额
	 */
	@ExcelAttribute(name = "单位大病救助金额" )
	@Schema(description = "单位大病救助金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病救助金额" )
	private BigDecimal unitBigailmentMoney;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例" )
	@Schema(description = "个人养老比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例" )
	private BigDecimal personalPersionPro;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额" )
	@Schema(description = "个人养老金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老金额" )
	private BigDecimal personalPersionMoney;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例" )
	@Schema(description = "个人医疗比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例" )
	private BigDecimal personalMedicalPro;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额" )
	@Schema(description = "个人医疗金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗金额" )
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例" )
	@Schema(description = "个人失业比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例" )
	private BigDecimal personalUnemploymentPro;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额" )
	@Schema(description = "个人失业金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业金额" )
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例" )
	@Schema(description = "个人大病比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例" )
	private BigDecimal personalBigailmentPro;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额" )
	@Schema(description = "个人大病金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额" )
	private BigDecimal personalBigailmentMoney;
	/**
	 * 单位公积金基数
	 */
	@ExcelAttribute(name = "单位公积金基数" )
	@Schema(description = "单位公积金基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金基数" )
	private BigDecimal unitFundBase;
	/**
	 * 个人公积金基数
	 */
	@ExcelAttribute(name = "个人公积金基数" )
	@Schema(description = "个人公积金基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金基数" )
	private BigDecimal personalFundBase;
	/**
	 * 单位公积金比例
	 */
	@ExcelAttribute(name = "单位公积金比例" )
	@Schema(description = "单位公积金比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例" )
	private BigDecimal unitFundProp;
	/**
	 * 个人公积金比例
	 */
	@ExcelAttribute(name = "个人公积金比例" )
	@Schema(description = "个人公积金比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金比例" )
	private BigDecimal personalFundProp;
	/**
	 * 单位公积金金额
	 */
	@ExcelAttribute(name = "单位公积金金额" )
	@Schema(description = "单位公积金金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金金额" )
	private BigDecimal unitFundMoney;
	/**
	 * 个人公积金金额
	 */
	@ExcelAttribute(name = "个人公积金金额" )
	@Schema(description = "个人公积金金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金金额" )
	private BigDecimal personalFundMoney;
	/**
	 * 缴纳类型（0最低、1自定义、2最高）
	 */
	@ExcelAttribute(name = "缴纳类型（0最低、1自定义、2最高）" )
	@Schema(description = "缴纳类型（0最低、1自定义、2最高）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳类型（0最低、1自定义、2最高）" )
	private Integer paymentType;
	/**
	 * 是否是社保：0否1是
	 */
	@ExcelAttribute(name = "是否是社保：0否1是" )
	@Schema(description = "是否是社保：0否1是" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否是社保：0否1是" )
	private Integer isSocial;
	/**
	 * 是否是公积金：0否1是
	 */
	@ExcelAttribute(name = "是否是公积金：0否1是" )
	@Schema(description = "是否是公积金：0否1是" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否是公积金：0否1是" )
	private Integer isFund;
	/**
	 * 社保公积金表id
	 */
	@Length(max = 32, message = "社保公积金表id 不能超过32个字符" )
	@ExcelAttribute(name = "社保公积金表id", maxLength = 32)
	@Schema(description = "社保公积金表id" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保公积金表id" )
	private String socialFundId;

}
