/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 社保变更记录表
 *
 * @author hgw
 * @date 2022-07-11 18:13:21
 */
@Data
@TableName("t_social_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保变更记录表")
public class TSocialLog extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelAttribute(name = "主键")
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;

	/**
	 * 类型：1社保基数配置；2公积金基数配置；3:调基
	 */
	@ExcelAttribute(name = "类型：1社保基数配置；2公积金基数配置；3:调基")
	@Schema(description = "类型：1社保基数配置；2公积金基数配置；3:调基")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：1社保基数配置；2公积金基数配置；3:调基")
	private Integer type;

	/**
	 * 主表id
	 */
	@ExcelAttribute(name = "主表id")
	@Schema(description = "主表id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主表id")
	private String mainId;

	/**
	 * 原来的信息
	 */
	@ExcelAttribute(name = "原来的信息")
	@Schema(description = "原来的信息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原来的信息")
	private String oldInfo;

	/**
	 * 新的信息
	 */
	@ExcelAttribute(name = "新的信息")
	@Schema(description = "新的信息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("新的信息")
	private String newInfo;

	/**
	 * 差异的信息(属性名称，逗号隔开)
	 */
	@ExcelAttribute(name = "差异的信息(属性名称，逗号隔开)")
	@Schema(description = "差异的信息(属性名称，逗号隔开)")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("差异的信息(属性名称，逗号隔开)")
	private String differenceInfo;

}
