package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author hgw
 * @Description 社保士兵自动办理导出
 * @Date 2024-5-13 10:56:51
 * @Param
 * @return
 **/
@Data
public class SocialSoldierBackVo implements Serializable {

	/**
	 * 派单ID
	 */
	@ExcelAttribute(name = "派单ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单ID")
	private String dispatchId;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "员工身份证", errorInfo = "员工身份证不能为空", maxLength = 20, needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工身份证")
	private String empIdcard;

	@ExcelAttribute(name = "养老工伤失业-办理状态", readConverterExp = "0=无,1=待办理,2=自动办理中,3=继续办理,4=中止办理,5=人工处理,6=成功,7=提交成功", needExport = true)
	@Schema(description = "养老工伤失业-办理状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老工伤失业-办理状态")
	private String ygsHandleStatus;

	@ExcelAttribute(name = "医保生育大病-办理状态", readConverterExp = "0=无,1=待办理,2=自动办理中,3=继续办理,4=中止办理,5=人工处理,6=成功,7=提交成功", needExport = true)
	@Schema(description = "医保生育大病-办理状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保生育大病-办理状态")
	private String ysdHandleStatus;

	@ExcelAttribute(name = "社保明细ID")
	@Schema(description = "社保明细ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保明细ID")
	private String socialId;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户", needExport = true)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;


	/**
	 * 请求ID
	 */
	@ExcelAttribute(name = "请求ID", needExport = true)
	@Schema(description = "请求ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("请求ID")
	private String requestId;



}
