/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.Date;

/**
 * 派单信息记录表-批量派减
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchReduceVo extends RowIndex implements Serializable {

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50, isNotEmpty = true)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码" )
	private String departNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50, isNotEmpty = true)
	@Schema(description = "员工姓名" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符" )
	@ExcelAttribute(name = "身份证号", maxLength = 20, isNotEmpty = true)
	@Schema(description = "身份证号" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号" )
	private String empIdcard;


	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = false)
	@Schema(description = "社保停缴日期：购买社保时必填" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保停缴日期" )
	private String socialReduceDate;

	/**
	 * 公积金停缴日期
	 */
	@ExcelAttribute(name = "公积金停缴日期", isDate = false)
	@Schema(description = "公积金停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金停缴日期" )
	private String fundReduceDate;

	/**
	 * 离职日期
	 */
	@ExcelAttribute(name = "离职日期", isDate = true)
	@Schema(description = "离职日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("离职日期" )
	private Date leaveDate;

	/**
	 * 减少原因
	 */
	@ExcelAttribute(name = "减少原因", isDataId = true,dataType = ExcelAttributeConstants.REDUCE_SOCIAL_REASON)
	@Schema(description = "减少原因" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减少原因" )
	private String reasonType;

	/**
	 * 委托备注
	 */
	@ExcelAttribute(name = "委托备注" , maxLength = 200,isDataId = true,dataType = ExcelAttributeConstants.TRUST_REMARK_REDUCE,isConvert = false)
	@Schema(description = "委托备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String trustRemark;

	/**
	 * 是否是失败项重新派单 0 是
	 */
	@ExcelAttribute(name = "是否是失败项重新派单")
	@Schema(description = "是否是失败项重新派单" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否是失败项重新派单" )
	private String isAgainFlag;

	/**
	 * 重新派单的ID
	 */
	@ExcelAttribute(name = "重新派单的ID")
	@Schema(description = "重新派单的ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("重新派单的ID" )
	private String isAgainId;

	/**
	 * 0 是 1 否
	 */
	@Length(max = 1, message = "是否同步终止合同、减项、减档不能超过1个字符")
	@ExcelAttribute(name = "是否同步终止合同、减项、减档", maxLength = 1,readConverterExp = "0=是,1=否")
	@Schema(description = "是否同步终止合同、减项、减档", name = "changeContractAndEmployee")
	@ExcelProperty("是否同步终止合同、减项、减档" )
	private String changeContractAndEmployee;

	/**
	 * 学历名称
	 */
	@ExcelAttribute(name = "学历",isNotEmpty = false)
	@Schema(description = "学历：派减只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学历")
	private String educationName;
}
