/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 *
 * @author huyc
 * @date 2023-07-18 11:38:05
 */
@Data
public class TDispatchSocialPersionExportVo implements Serializable {

	/**
	 * 序号
	 */
	@Schema(description = "序号" )
	@ExcelAttribute(name = "序号" )
	@ExcelProperty("序号")
	private Integer num;
	/**
	 * 员工姓名
	 */
	@Schema(description = "姓名" )
	@ExcelAttribute(name = "姓名" )
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 职工编码
	 */
	@Schema(description = "职工编码" )
	@ExcelAttribute(name = "职工编码" )
	@ExcelProperty("职工编码")
	private String empNo;
	/**
	 * 社会保障号码
	 */
	@Schema(description = "社会保障号码（身份证号码）" )
	@ExcelAttribute(name = "社会保障号码（身份证号码）" )
	@ExcelProperty("社会保障号码（身份证号码）")
	private String empIdcard;
	/**
	 * 性别：1男 2女
	 */
	@ExcelAttribute(name = "性别" )
	@ExcelProperty("性别")
	@Schema(description ="性别")
	private String sex;
	/**
	 * 民族
	 */
	@Schema(description = "民族")
	@ExcelAttribute(name = "民族")
	@ExcelProperty("民族")
	private String empNational;
	/**
	 * 参加工作时间
	 */
	@Schema(description = "参加工作时间" )
	@ExcelAttribute(name = "参加工作时间" )
	@ExcelProperty("参加工作时间")
	private String workDate;
	/**
	 * 户口性质
	 */
	@Schema(description = "户口性质" )
	@ExcelAttribute(name = "户口性质" )
	@ExcelProperty("户口性质")
	private String type;
	/**
	 * 个人身份
	 */
	@Schema(description = "个人身份" )
	@ExcelAttribute(name = "个人身份" )
	@ExcelProperty("个人身份")
	private String signleType;
	/**
	 * 养老
	 */
	@Schema(description = "养老" )
	@ExcelAttribute(name = "养老" )
	@ExcelProperty("养老")
	private String insuranceTypeOne;
	/**
	 * 失业
	 */
	@Schema(description = "失业" )
	@ExcelAttribute(name = "失业" )
	@ExcelProperty("失业")
	private String insuranceTypeTwo;
	/**
	 * 医疗
	 */
	@Schema(description = "医疗" )
	@ExcelAttribute(name = "医疗" )
	@ExcelProperty("医疗")
	private String insuranceTypeThree;
	/**
	 * 工伤
	 */
	@Schema(description = "工伤" )
	@ExcelAttribute(name = "工伤" )
	@ExcelProperty("工伤")
	private String insuranceTypeFour;
	/**
	 * 生育
	 */
	@Schema(description = "生育" )
	@ExcelAttribute(name = "生育" )
	@ExcelProperty("生育")
	private String insuranceTypeFive;

	/**
	 * 月工资收入(元)
	 */
	@Schema(description = "月工资收入(元)" )
	@ExcelAttribute(name = "月工资收入(元)" )
	@ExcelProperty("月工资收入(元)")
	private BigDecimal persionCardinal;

	/**
	 * 补缴保险属期
	 */
	@Schema(description = "补缴保险属期" )
	@ExcelAttribute(name = "补缴保险属期" )
	@ExcelProperty("补缴保险属期")
	private String dateOne;
	/**
	 * 户籍所在地
	 */
	@Schema(description = "户籍所在地")
	@ExcelAttribute(name = "户籍所在地" )
	@ExcelProperty("户籍所在地")
	private String contactAddress;

	/**
	 * 学历
	 */
	@Schema(description = "备注")
	@ExcelAttribute(name = "备注" )
	@ExcelProperty("备注")
	private String remark;
}
