package com.yifu.cloud.plus.v1.yifu.social.config;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CustomCellStyleTwoStrategy extends AbstractVerticalCellStyleStrategy {

	/**
	 * 操作列
	 */
	private List<Integer> columnIndexes;

	public CustomCellStyleTwoStrategy(List<Integer> columnIndexes ) {
		this.columnIndexes = columnIndexes;
	}

	@Override
	protected WriteCellStyle headCellStyle(Head head) {

		// 获取样式实例
		WriteCellStyle headWriteCellStyle = new WriteCellStyle();
		// 获取字体实例
		WriteFont headWriteFont = new WriteFont();
		// 设置字体样式
		headWriteFont.setFontName("宋体");
		// 设置字体大小
		headWriteFont.setFontHeightInPoints((short)12);
		// 边框
		headWriteFont.setBold(false);
		headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
		headWriteCellStyle.setWriteFont(headWriteFont);
		headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
		headWriteCellStyle.setBorderLeft(BorderStyle.NONE);
		headWriteCellStyle.setBorderBottom(BorderStyle.NONE);
		headWriteCellStyle.setBorderRight(BorderStyle.NONE);
		headWriteCellStyle.setBorderTop(BorderStyle.NONE);
		return headWriteCellStyle;
	}
}