/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysHouseHoldInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TSocialHouseholdExportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 社保户公积金户数据
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
@Mapper
public interface SysHouseHoldInfoMapper extends BaseMapper<SysHouseHoldInfo> {
    /**
	 * 社保户公积金户数据简单分页查询
	 * @param sysHouseHoldInfo 社保户公积金户数据
	 * @return
	 */
	IPage<SysHouseHoldInfo> getSysHouseHoldInfoPage(Page<SysHouseHoldInfo> page, @Param("sysHouseHoldInfo") SysHouseHoldInfo sysHouseHoldInfo);

	/**
	 * 获取所有的独立户数据
	 * @param page
	 * @return
	 */
	IPage<SysHouseHoldInfo> getAllSingleSocailPage(Page<SysHouseHoldInfo> page);

	/**
	 * 查询导出的数量
	 * @param sysHouseHoldInfo
	 * @return
	 */
	long selectExportCount(@Param("sysHouseHoldInfo") SysHouseHoldInfo sysHouseHoldInfo);

	/**
	 * 查询导出的集合
	 * @param sysHouseHoldInfo
	 * @return
	 */
	List<TSocialHouseholdExportVo> selectExportList(@Param("sysHouseHoldInfo") SysHouseHoldInfo sysHouseHoldInfo);

	/**
	 * @Description: 获取自动生成解除劳动合同的户与公章
	 * @Author: hgw
	 * @Date: 2025/5/26 17:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.entity.SysHouseHoldInfo>
	 **/
	List<SysHouseHoldInfo> getAttaSrcByAutoDoc();

	/**
	 * @Author fxj
	 * @Description 获取启用自动化的户信息
	 * @Date 9:35 2025/7/17
	 * @Param
	 * @return
	**/
	List<SysHouseHoldInfo> getHouseInfoAutoDoc();

}
