/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialLog;
/**
 * 社保变更记录表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
public interface TSocialLogService extends IService<TSocialLog> {
	/**
	 * 社保变更记录表简单分页查询
	 *
	 * @param tSocialLog 社保变更记录表
	 * @return
	 */
	IPage<TSocialLog> getTSocialLogPage(Page<TSocialLog> page, TSocialLog tSocialLog);

	/**
	 * 生成修改记录
	 *
	 * @param type    类型：1社保基数配置；2公积金基数配置
	 * @param mainId  关联表id
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 * @Author pwang
	 * @Date 2022-06-22 11:32
	 **/
	<T> TSocialLog saveModificationRecord(Integer type, String mainId, T oldInfo, T newInfo);

}
