/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 瓜子采集字段配置表（前端用配置进行展示）
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Data
@TableName("sys_out_emp_form_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子采集字段配置表（前端用配置进行展示）")
public class SysOutEmpFormInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;
	/**
	 * 归属分类ID
	 */
	@Length(max = 32, message = "归属分类ID不能超过32个字符")
	@Schema(description = "归属分类ID")
	private String categorizeId;
	/**
	 * 字段标识名称
	 */
	@Length(max = 100, message = "字段标识名称不能超过100个字符")
	@Schema(description = "字段标识名称")
	private String fieldName;
	/**
	 * 字段中文名称
	 */
	@Length(max = 100, message = "字段中文名称不能超过100个字符")
	@Schema(description = "字段中文名称")
	private String fieldZhName;
	/**
	 * 排序
	 */
	@Schema(description = "排序")
	private Integer sort;
	/**
	 * C端是否可见（0：是，1：否）
	 */
	@Length(max = 1, message = "C端是否可见（0：是，1：否）不能超过1个字符")
	@Schema(description = "C端是否可见（0：是，1：否）")
	private String isLookToc;
	/**
	 * 是否员工侧填写（1：系统带出不可编辑，2：系统带出可编辑，3：系统未带出员工填写）
	 */
	@Length(max = 2, message = "是否员工侧填写（1：系统带出不可编辑，2：系统带出可编辑，3：系统未带出员工填写）不能超过2个字符")
	@Schema(description = "是否员工侧填写（1：系统带出不可编辑，2：系统带出可编辑，3：系统未带出员工填写）")
	private String empFillType;
	/**
	 * 字段状态( 0正常 1停用)
	 */
	@Length(max = 1, message = "字段状态( 0正常 1停用)不能超过1个字符")
	@Schema(description = "字段状态( 0正常 1停用)")
	private String fieldStatus;
	/**
	 * 字段类型( 1：文本，2：下拉单选，3：下拉多选，4：省市区控件，5：开户支行控件，6：附件，7：年月日控件)
	 */
	@Length(max = 2, message = "字段类型( 1：文本，2：下拉单选，3：下拉多选，4：省市区控件，5：开户支行控件，6：附件，7：年月日控件)不能超过2个字符")
	@Schema(description = "字段类型( 1：文本，2：下拉单选，3：下拉多选，4：省市区控件，5：开户支行控件，6：附件，7：年月日控件)")
	private String fieldType;
	/**
	 * 对应字典标识
	 */
	@Length(max = 100, message = "对应字典标识不能超过100个字符")
	@Schema(description = "对应字典标识")
	private String dictType;
	/**
	 * 是否必填(0：是，1：否，2：联动必填)
	 */
	@Length(max = 2, message = "是否必填(0：是，1：否，2：联动必填)不能超过2个字符")
	@Schema(description = "是否必填(0：是，1：否，2：联动必填)")
	private String isRequired;
	/**
	 * 联动必填时，联动字段
	 */
	@Length(max = 100, message = "联动必填时，联动字段不能超过100个字符")
	@Schema(description = "联动必填时，联动字段")
	private String relField;
	/**
	 * 联动必填时，联动字段值
	 */
	@Length(max = 100, message = "联动必填时，联动字段值不能超过100个字符")
	@Schema(description = "联动必填时，联动字段值")
	private String relFieldValue;
	/**
	 * 删除标记
	 */
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

	/**
	 * 是否有映射关系（0：是，1：否）
	 */
	@Length(max = 1, message = "是否有映射关系（0：是，1：否）不能超过1个字符")
	@Schema(description = "是否有映射关系（0：是，1：否）")
	private String haveWanxinMapping;
	/**
	 * 有映射关系时，映射类型（0：字段映射，1：字典值映射）
	 */
	@Length(max = 1, message = "有映射关系时，映射类型（0：字段映射，1：字典值映射）不能超过1个字符")
	@Schema(description = "有映射关系时，映射类型（0：字段映射，1：字典值映射）")
	private String wanxinMappingType;
	/**
	 * 有映射关系时，皖信字段标识名称
	 */
	@Length(max = 100, message = "有映射关系时，皖信字段标识名称不能超过100个字符")
	@Schema(description = "有映射关系时，皖信字段标识名称")
	private String wanxinFieldName;
	/**
	 * 有映射关系时，皖信字段中文名称
	 */
	@Length(max = 100, message = "有映射关系时，皖信字段中文名称不能超过100个字符")
	@Schema(description = "有映射关系时，皖信字段中文名称")
	private String wanxinFieldZhName;
	/**
	 * 有映射关系时，皖信字段类型( 1：文本，2：下拉单选，3：下拉多选，4：省市区控件，5：开户支行控件，6：附件，7：年月日控件)
	 */
	@Length(max = 2, message = "有映射关系时，皖信字段类型( 1：文本，2：下拉单选，3：下拉多选，4：省市区控件，5：开户支行控件，6：附件，7：年月日控件)不能超过2个字符")
	@Schema(description = "有映射关系时，皖信字段类型( 1：文本，2：下拉单选，3：下拉多选，4：省市区控件，5：开户支行控件，6：附件，7：年月日控件)")
	private String wanxinFieldType;
	/**
	 * 是否校验(0：是，1：否)
	 */
	@Length(max = 2, message = "是否校验(0：是，1：否)不能超过2个字符")
	@Schema(description = "是否校验(0：是，1：否)")
	private String isCheck;
	/**
	 * 校验规则（前端提供）
	 */
	@Length(max = 100, message = "校验规则（前端提供）不能超过100个字符")
	@Schema(description = "校验规则（前端提供）")
	private String checkValue;

}
