/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 项目下用户部门及权限
 *
 * @author chenyuxi
 * @since 1.9.7
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SysUserDeptPermission extends Model<SysUserDeptPermission> {

	private static final long serialVersionUID = 1L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	@Schema(description = "主键id")
	private String id;

	@NotBlank(message = "用户id 不能为空")
	@Schema(description = "用户id")
	private String userId;

	@NotBlank(message = "部门id 不能为空")
	@Schema(description = "部门id")
	private Long deptId;

	@NotBlank(message = "关联项目编码 不能为空")
	@Schema(description = "关联项目编码")
	private String projectNo;

	@NotBlank(message = "关联项目名称 不能为空")
	@Schema(description = "关联项目名称")
	private String projectName;

	@NotBlank(message = "关联项目ID 不能为空")
	@Schema(description = "关联项目ID")
	private String projectId;

	@Schema(description = "归属系统 yifu-mvp、yifu-csp")
	private String client;

	@NotBlank(message = "账号类型 不能为空")
	@Schema(description = "账号类型：0 管理员， 1 普通成员")
	private String userType;

	@Schema(description = "数据权限(0:全部数据,1:二级部门及以下,2:本部门及以下,3:指定部门)")
	private String permissionsType;

	@Schema(description = "指定部门范围（部门id用逗号隔开）")
	private String appointDeptScope;

}
