/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 法大大专业版模版表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
public class TFascTemplateUpdateVo extends RowIndex implements Serializable {

	/**
	 * 模版ID
	 */
	@NotBlank(message = "模版ID 不能为空")
	@Length(max = 100, message = "模版ID 不能超过100 个字符")
	@ExcelAttribute(name = "模版ID", isNotEmpty = true, errorInfo = "模版ID 不能为空", maxLength = 100)
	@Schema(description = "模版ID")
	@ExcelProperty("模版ID")
	private String signTemplateId;
	/**
	 * 模版名称
	 */
	@Length(max = 100, message = "模版名称 不能超过100 个字符")
	@ExcelAttribute(name = "模版名称", isNotEmpty = true, errorInfo = "模版名称 不能为空", maxLength = 100)
	@Schema(description = "模版名称")
	@ExcelProperty("模版名称")
	private String signTemplateName;
	/**
	 * 皖信合同类型
	 */
	@Length(max = 32, message = "皖信合同类型 不能超过32 个字符")
	@ExcelAttribute(name = "皖信合同类型", isNotEmpty = true, errorInfo = "皖信合同类型 不能为空", maxLength = 32)
	@Schema(description = "皖信合同类型")
	@ExcelProperty("皖信合同类型")
	private String contractType;

}
