/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpOtherFile;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TPreEmpOtherFileMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAttaInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TPreEmpOtherFileService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.net.URL;
import java.util.List;

/**
 * 预入职-其他附件主表
 *
 * @author hgw
 * @date 2024-07-17 14:56:34
 */
@Log4j2
@AllArgsConstructor
@Service
public class TPreEmpOtherFileServiceImpl extends ServiceImpl<TPreEmpOtherFileMapper, TPreEmpOtherFile> implements TPreEmpOtherFileService {

	// 附件21（预入职申明签名）；22（预入职确认签名）；23（预入职pdf文件)
	private final TAttaInfoService tAttaInfoService;
	private final OSSUtil ossUtil;
	/**
	 * 预入职-其他附件主表
	 *
	 * @return
	 */
	@Override
	public List<TPreEmpOtherFile> getTPreEmpOtherFileList(String preMainId) {
		return baseMapper.getOtherFileList(preMainId);
	}

	/**
	 * 预入职-其他附件主表
	 *
	 * @return
	 */
	@Override
	public List<TPreEmpOtherFile> getTPreEmpOtherFileListAndFile(String preMainId) {
		List<TPreEmpOtherFile> list = baseMapper.getOtherFileList(preMainId);
		if (list != null && !list.isEmpty()) {
			URL url;
			List<TAttaInfo> attaInfoList;
			for (TPreEmpOtherFile info : list) {
				// 附件
				attaInfoList = tAttaInfoService.getTAttaInfoListByDoMainId(info.getId());
				if (attaInfoList != null && !attaInfoList.isEmpty()) {
					for (TAttaInfo atta : attaInfoList) {
						url = ossUtil.getObjectUrl(null, atta.getAttaSrc());
						atta.setAttaUrl(String.valueOf(url));
					}
				}
				info.setAttaList(attaInfoList);
			}
		}
		return list;
	}

	@Override
	public void deleteOtherFileByMainId(String preMainId) {
		baseMapper.deleteOtherFileByMainId(preMainId);
	}
}
