/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsLabor;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsLaborSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 本期劳务费申报表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TStatisticsLaborService extends IService<TStatisticsLabor> {
    /**
     * 本期劳务费申报表简单分页查询
     * @param tStatisticsLabor 本期劳务费申报表
     * @return
     */
    IPage<TStatisticsLabor> getTStatisticsLaborPage(Page<TStatisticsLabor> page, TStatisticsLaborSearchVo tStatisticsLabor);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TStatisticsLaborSearchVo searchVo);

    List<TStatisticsLabor> noPageDiy(TStatisticsLaborSearchVo searchVo);

	/**
	 * 批量删除本期劳务费申报表
	 * @param declareMonth 申报月份
	 * @return
	 */
	R batchDelete(String declareMonth);

	/**	生成本期劳务费
	 * @param
	 * @return
	 **/
	R doStatisticsLabor();

	/**	手动刷新生成本期劳务费
	 * @param
	 * @return
	 **/
	R refreshStatisticsLabor(String declareMonth);
}
