package com.yifu.cloud.plus.v1.yifu.social.util;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.CheckedException;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundHistory;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 公用方法提取
 *
 * @author fxj
 * @date 2019-09-29
 **/
@Slf4j
public class ServiceUtil {
	private ServiceUtil() {
		throw new IllegalStateException("ServiceUtil class");
	}

	/**
	 * @Description: 返回字符串对应的int值
	 * @Date: 2022/7/18 17:29
	 **/
	public static int convertStringToInt(String num1) {
		if (Common.isEmpty(num1) || !Common.isNumber(num1)) {
			return -1;
		}
		return Integer.parseInt(num1);
	}

	/**
	 * 按派单日期生成生成月份
	 * @Author fxj
	 * @Date 2020-03-25
	 * @param createDate
	 * @return
	 **/
	public static String  initCreateMonth(LocalDateTime createDate, String payMonth){
		if (null == createDate || Common.isEmpty(payMonth) || payMonth.length() != 6){
			return DateUtil.getYearAndMonth(LocalDateTime.now(), 1);
		}
		if (createDate.getYear() < Integer.parseInt(payMonth.substring(0,4))){
			return  payMonth;
		}
		if (createDate.getYear() > Integer.parseInt(payMonth.substring(0,4))){
			return DateUtil.getYearAndMonth(createDate, 1);
		}
		if (createDate.getYear() == Integer.parseInt(payMonth.substring(0,4))){
			if (createDate.getMonthValue() < Integer.parseInt(payMonth.substring(4,6))){
				return  payMonth;
			}
			if (createDate.getMonthValue() >= Integer.parseInt(payMonth.substring(4,6))){
				return DateUtil.getYearAndMonth(createDate, 1);
			}
		}
		return  null;
	}

	/**
	 * 抛个异常先
	 * @Author fxj
	 * @Date 2020-09-09
	 * @param errorInfo
	 * @return
	 **/
	public static void runTimeExceptionDiy(String errorInfo) {
		throw new CheckedException(errorInfo);
	}

	/**
	 * 参数2的是否大于等于参数1的
	 * @Author fxj
	 * @Date 20200403
	 * @param socialStartDate
	 * @param socialPayMonth
	 * @param reduceDate
	 * @return
	 **/
	public static boolean checkMothForPaymentImport(Date socialStartDate, String socialPayMonth, Date reduceDate) {
		if(socialStartDate != null) {
			if (null == reduceDate){
				if(Integer.parseInt(socialPayMonth) >= Integer.parseInt(DateUtil.dateToString(socialStartDate).replace("-",""))){
					return true;
				}
			}else {
				if(Integer.parseInt(socialPayMonth) >= Integer.parseInt(DateUtil.dateToString(socialStartDate))
						&& Integer.parseInt(socialPayMonth) < Integer.parseInt(DateUtil.dateToString(reduceDate).replace("-",""))){
					return true;
				}
			}
		}
		return false;
	}

	public static BigDecimal ifNull(BigDecimal old, BigDecimal last){
		if (Common.isEmpty(old)){
			return last;
		}
		return old;
	}
	public static Date ifNull(Date old,Date last){
		if (Common.isEmpty(old)){
			return last;
		}
		return old;
	}
	public static String ifNullToEmpty(String str){
		if (Common.isEmpty(str)){
			return CommonConstants.EMPTY_STRING;
		}
		return str;
	}

	public static String replaceSeparator(String string,String str1, String... strn){
		if (null != str1) {
			string = string.replace(str1,CommonConstants.EMPTY_STRING);
		}
		if (null != strn) {
			for (String str : strn) {
				string = string.replace(str,CommonConstants.EMPTY_STRING);
			}
		}
		return string;
	}

	/**
	 * 验证公积金 比例 是否符合公积金基数配置
	 * @Author fxj
	 * @Date 2019-09-29
	 * @param lst
	 * @return
	 **/
	public static boolean checkFundPercentByList(List<SysPayProportion> lst, TSocialFundHistory infoVo){
		if (Common.isEmpty(lst)){
			return false;
		}
		if (null == infoVo || null == infoVo.getUnitFundProp()){
			return false;
		}
		if (Common.isNotNull(lst)){
			for (SysPayProportion t:lst){
				if (infoVo.getUnitFundProp().compareTo(BigDecimal.valueOf(t.getCompanyPro())) ==  CommonConstants.ZERO_INT
						&& infoVo.getPersonalFundProp().compareTo(BigDecimal.valueOf(t.getPersonalPro())) ==  CommonConstants.ZERO_INT){
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 查看社保公积金起缴日期是否符合补缴逻辑
	 * @Author fxj
	 * @Date 2020-09-07
	 * @param socialStartDate  起缴日期
	 * @param canOverpay  是否可补缴 0：是，1：否
	 * @param overpayNumber  补缴期限 整数
	 * @param haveThisMonth 是否含当月 0：是，1：否   如果无符合条件默认不含当月
	 * @return 符合 false  不符合 true
	 **/
	public  static boolean checkDispatchDate(LocalDateTime socialStartDate,String canOverpay,Integer overpayNumber,String haveThisMonth){
		if (null == socialStartDate){
			return false;
		}
		LocalDateTime temp = null;
		LocalDateTime now = LocalDateTime.now();
		if (CommonConstants.ZERO_STRING.equals(canOverpay)){
			temp = socialStartDate.plusMonths(CommonConstants.ZERO_STRING.equals(haveThisMonth)?(long)(overpayNumber-1):(long)(overpayNumber));
		}else if (CommonConstants.ONE_STRING.equals(canOverpay)){
			temp = socialStartDate;
		}
		return (null != temp && (temp.getYear() < now.getYear() || isaBoolean(temp, now)));
	}
	private static boolean isaBoolean(LocalDateTime temp, LocalDateTime now) {
		return temp.getYear() == now.getYear() && temp.getMonthValue() < now.getMonthValue();
	}
}
