/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutRelDict;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutRelDictService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 外部字典与皖信字典的映射关系表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysoutreldict" )
@Tag(name = "外部字典与皖信字典的映射关系表管理")
public class SysOutRelDictController {

    private final  SysOutRelDictService sysOutRelDictService;


    /**
     * 不分页查询
     * @param sysOutRelDict 外部字典与皖信字典的映射关系表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<SysOutRelDict>> getSysOutRelDictNoPage(@RequestBody SysOutRelDict sysOutRelDict) {
        return R.ok(sysOutRelDictService.noPageDiy(sysOutRelDict));
    }

    /**
     * 通过id查询外部字典与皖信字典的映射关系表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('admin_sysoutreldict_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldict_get')" )
    public R<SysOutRelDict> getById(@PathVariable("id" ) Long id) {
        return R.ok(sysOutRelDictService.getById(id));
    }

    /**
     * 新增外部字典与皖信字典的映射关系表
     * @param sysOutRelDict 外部字典与皖信字典的映射关系表
     * @return R
     */
    @Operation(summary = "新增外部字典与皖信字典的映射关系表", description = "新增外部字典与皖信字典的映射关系表：hasPermission('admin_sysoutreldict_add')")
    @SysLog("新增外部字典与皖信字典的映射关系表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldict_add')" )
    public R<Boolean> save(@RequestBody SysOutRelDict sysOutRelDict) {
        return R.ok(sysOutRelDictService.save(sysOutRelDict));
    }

    /**
     * 修改外部字典与皖信字典的映射关系表
     * @param sysOutRelDict 外部字典与皖信字典的映射关系表
     * @return R
     */
    @Operation(summary = "修改外部字典与皖信字典的映射关系表", description = "修改外部字典与皖信字典的映射关系表：hasPermission('admin_sysoutreldict_edit')")
    @SysLog("修改外部字典与皖信字典的映射关系表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldict_edit')" )
    public R<Boolean> updateById(@RequestBody SysOutRelDict sysOutRelDict) {
        return R.ok(sysOutRelDictService.updateById(sysOutRelDict));
    }

    /**
     * 通过id删除外部字典与皖信字典的映射关系表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除外部字典与皖信字典的映射关系表", description = "通过id删除外部字典与皖信字典的映射关系表：hasPermission('admin_sysoutreldict_del')")
    @SysLog("通过id删除外部字典与皖信字典的映射关系表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutreldict_del')" )
    public R<Boolean> removeById(@PathVariable Long id) {
        return R.ok(sysOutRelDictService.removeById(id));
    }

}
