package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeRoute;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeRouteService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;


/**
 * 流程路由表（节点与节点之间的路由关系）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnoderoute")
@Tag(name = "流程路由表（节点与节点之间的路由关系）")
public class TNodeRouteController {

	@Resource
     private TNodeRouteService tNodeRouteService;

     /**
      * 简单分页查询
      *
      * @param page       分页对象
      * @param tNodeRoute 流程路由表（节点与节点之间的路由关系）
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodeRoute>> getTNodeRoutePage(Page<TNodeRoute> page, TNodeRoute tNodeRoute) {
          return new R<>(tNodeRouteService.getTNodeRoutePage(page, tNodeRoute));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodeRoute> getById(@PathVariable("id") String id) {
          return new R<>(tNodeRouteService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodeRoute
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodeRoute tNodeRoute) {
          return new R<>(tNodeRouteService.save(tNodeRoute));
     }

     /**
      * 修改记录
      *
      * @param tNodeRoute
      * @return R
      */
	 @Operation(summary = "修改(yifu-module:tnoderoute_edit)")
     @SysLog("修改流程路由表（节点与节点之间的路由关系）")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodeRoute tNodeRoute) {
          return new R<>(tNodeRouteService.updateById(tNodeRoute));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除流程路由表（节点与节点之间的路由关系）")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodeRouteService.removeById(id));
     }

     /**
      * todo 功能描述: 根据流程id查询路由记录
      * @Param: [processId]
      * @Return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List<TNodeRoute>>
      * @Author: zhouyang
      * @Date: 2021/9/3 11:46
      */
     @Inner
     @GetMapping("/inner/getNodeRoute/byProcessId")
     public R<List<TNodeRoute>> getNodeRouteByProcessId(@RequestParam("processId") String processId) {
          List<TNodeRoute> tNodeRoute = tNodeRouteService.list(Wrappers.<TNodeRoute>query().lambda().eq(TNodeRoute::getProcessId, processId));
          return new R<>(tNodeRoute);
     }
}
