package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.LExcelHeadForIo;
import com.yifu.cloud.plus.v1.yifu.archives.service.LExcelHeadForIoService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @Author fxj
 * @Description 用户表格导入导出默认表头数据
 * @Date 9:59 2022/9/20
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/lexcelheadforio")
@Tag(name = "用户表格导入导出默认表头数据")
public class LExcelHeadForIoController {

    private final LExcelHeadForIoService lExcelHeadForIoService;

    /**
     * 简单分页查询
     *
     * @param page            分页对象
     * @param lExcelHeadForIo 用户表格导入导出默认表头数据
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<LExcelHeadForIo>> getLExcelHeadForIoPage(Page<LExcelHeadForIo> page, LExcelHeadForIo lExcelHeadForIo) {
        return new R<>(lExcelHeadForIoService.getLExcelHeadForIoPage(page, lExcelHeadForIo));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "id查询")
    @GetMapping("/{id}")
    public R<LExcelHeadForIo> getById(@PathVariable("id") String id) {
        return new R<>(lExcelHeadForIoService.getById(id));
    }
    /**
     * 通过useCode查询本人配置
     *
     * @param useCode
     * @return R
     */
    @Operation(description = "通过useCode查询本人配置")
    @GetMapping("/getOwnList/{useCode}")
    public R<List<LExcelHeadForIo>> getOwnListByUseCode(@PathVariable("useCode") String useCode) {
        YifuUser user = SecurityUtils.getUser();
        return new R<>(lExcelHeadForIoService.list(Wrappers.<LExcelHeadForIo>lambdaQuery()
				.eq(LExcelHeadForIo::getCreateUser, String.valueOf(user.getId()))
				.eq(LExcelHeadForIo::getUseCode, useCode)));
    }

    /**
     * 新增记录
     *
     * @param lExcelHeadForIo
     * @return R
     */
    @Operation(description = "新增 maxMun:最大配置项（不传默认3）")
    @PostMapping
    public R<Boolean> save(@Valid @RequestBody LExcelHeadForIo lExcelHeadForIo,Integer maxMun) {
		YifuUser user = SecurityUtils.getUser();
        if(null == maxMun){
            maxMun = CommonConstants.dingleDigitIntArray[3];
        }
        lExcelHeadForIo.setCreateUser(String.valueOf(user.getId()));
        lExcelHeadForIo.setCreateTime(LocalDateTime.now());
        long count = lExcelHeadForIoService.count(Wrappers.<LExcelHeadForIo>lambdaQuery()
				.eq(LExcelHeadForIo::getCreateUser, lExcelHeadForIo.getCreateUser())
				.eq(LExcelHeadForIo::getUseCode, lExcelHeadForIo.getUseCode()));
        if(maxMun <= count){
            return R.failed("保存失败，配置项不能超过最大配置数".concat(String.valueOf(maxMun)));
        }
        return new R<>(lExcelHeadForIoService.save(lExcelHeadForIo));
    }

    /**
     * 修改记录
     *
     * @param lExcelHeadForIo
     * @return R
     */
    @Operation(description = "修改(wxhr:lexcelheadforio_edit)")
    @SysLog("修改用户表格导入导出默认表头数据")
    @PutMapping
    public R<Boolean> update(@RequestBody LExcelHeadForIo lExcelHeadForIo) {
        if(Common.isEmpty(lExcelHeadForIo.getId())){
           return R.failed("操作失败，id不能为空！");
        }
        LExcelHeadForIo eh = lExcelHeadForIoService.getById(lExcelHeadForIo.getId());
        if(null == eh ){
			return  R.failed("操作失败，无此配置！");
        }
        YifuUser user = SecurityUtils.getUser();
        if(String.valueOf(user.getId()).equals(eh.getCreateUser())){
            lExcelHeadForIo.setCreateTime(null);
            lExcelHeadForIo.setCreateUser(null);
            return new R<>(lExcelHeadForIoService.updateById(lExcelHeadForIo));
        }else{
            return R.failed("操作失败，此配置不属于您，您无权修改！");
        }

    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "删除(wxhr:lexcelheadforio_del)")
    @SysLog("删除用户表格导入导出默认表头数据")
    @DeleteMapping("/{id}")
    public R<Boolean> removeById(@PathVariable String id) {
        LExcelHeadForIo eh = lExcelHeadForIoService.getById(id);
        if(null == eh ){
			return R.failed("数据库存着此配置，无需重复删除！");
        }
        YifuUser user = SecurityUtils.getUser();
        if(String.valueOf(user.getId()).equals(eh.getCreateUser())){
            return new R<>(lExcelHeadForIoService.removeById(id));
        }else{
            return R.failed("操作失败，此配置不属于您，您无权删除！");
        }
    }

}
