/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractAttachInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

import java.util.List;

/**
 * 法大大合同附属信息表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
public interface FddContractAttachInfoService extends IService<FddContractAttachInfo> {

	/**
	 * 法大大合同附属信息表简单分页查询
	 * @param fddContractAttachInfo 法大大合同附属信息表
	 * @return
	 */
	IPage<FddContractAttachInfo> getFddContractAttachInfoPage(Page<FddContractAttachInfo> page, FddContractAttachInfo fddContractAttachInfo);

	/**
	 * 获取有附属信息但是没有法大大电子合同的数据
	 * @param empIdcard
	 * @return
	 */
	List<FddContractAttachInfo> getListByNoInfoByEmpIdcard(String empIdcard);

	List<ErrorMessage> sendTask(List<FddContractAttachInfo> entityList);

	R<String> saveEmpAndAttarch(FddContractInfo fddContractInfo, YifuUser user);

	List<ErrorMessage> batchAdd(List<FddContractAttachInfo> entityList);

	List<ErrorMessage> batchUpdate(List<FddContractAttachInfo> entityList);
}
