/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpAlertTableService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamRisk;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 预警配置表
 *
 * @author fxj
 * @date 2025-07-21 09:49:56
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpalerttable")
@Tag(name = "预警配置表管理")
public class EkpAlertTableController {

	private final EkpAlertTableService ekpAlertTableService;

	/**
	 * @return
	 * @Author fxj
	 * @Description 定时任务推送 预算超额预警信息 按日推送
	 * @Date 10:03 2025/7/21
	 * @Param
	 **/
	@Inner
	@PostMapping("/inner/pushBudgetAlertInfoTomanager")
	public void pushRiskInfoToEkp() {
		ekpAlertTableService.pushBudgetAlertInfoTomanager(1);

	}

	/**
	 * @return
	 * @Author fxj
	 * @Description 定时任务推送 预算超额预警信息 按月推送
	 * @Date 10:03 2025/7/21
	 * @Param
	 **/
	@Inner
	@PostMapping("/inner/pushBudgetAlertInfoTomanagerMonth")
	public void pushBudgetAlertInfoTomanagerMonth() {
		ekpAlertTableService.pushBudgetAlertInfoTomanager(0);

	}

	/**
	 * @Author fxj
	 * @Description 企业微信智能表格API调用调试入口
	 * @Date 15:56 2025/9/26
	 * @Param
	 * @return
	**/
	@PostMapping("/tesxWxExcelApi")
	public void tesxWxExcelApi() {
		//ekpAlertTableService.tesxWxExcelApi();

	}
}
