package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.constants.InsurancesConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceOperate;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceTypeRateMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceOperateService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeRateService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type_rate(费率表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:33
*/
@Service
public class TInsuranceTypeRateServiceImpl extends ServiceImpl<TInsuranceTypeRateMapper, TInsuranceTypeRate> implements TInsuranceTypeRateService {

	@Resource
	private TInsuranceTypeService insuranceTypeService;

	@Resource
	private TInsuranceOperateService tInsuranceOperateService;

	/**
	 * 根据险种id查询费率列表
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link List< TInsuranceTypeRate>}
	 */
	@Override
	public R getInsuranceTypeRateList(String id) {
		if (Common.isEmpty(id)){
			return R.failed("险种为空");
		}
		TInsuranceType byId = insuranceTypeService.getById(id);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("该险种信息不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceTypeRate> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeRate::getDeleteFlag, CommonConstants.ZERO_INT).eq(TInsuranceTypeRate::getInsuranceTypeId,id);
		queryWrapper.orderByDesc(TInsuranceTypeRate::getCreateTime);
		return R.ok(list(queryWrapper));
	}

	/**
	 * 删除费率
	 *
	 * @author zhaji
	 * @param id 费率id
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R deleteInsuranceTypeRate(String id) {
		YifuUser user = SecurityUtils.getUser();
		if(Common.isEmpty(id)){
			return R.failed("费率id不能为空");
		}
		TInsuranceTypeRate byId = getById(id);
		if (Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("费率信息不存在或已被删除");
		}
		LambdaUpdateWrapper<TInsuranceTypeRate> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(TInsuranceTypeRate::getId,id)
				.set(TInsuranceTypeRate::getDeleteFlag, CommonConstants.ONE_INT)
				.set(TInsuranceTypeRate :: getUpdateBy,user.getId())
				.set(TInsuranceTypeRate :: getUpdateTime, LocalDateTime.now());
		update(updateWrapper);
		addOperate(byId,user, InsurancesConstants.DELETE_INSURANCE_TYPE_RATE);
		return R.ok("删除费率信息成功");
	}

	/**
	 * 新增费率
	 *
	 * @author zhaji
	 * @param insuranceTypeRate 费率信息
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R saveInsuranceTypeRate(TInsuranceTypeRate insuranceTypeRate) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(insuranceTypeRate)){
			return R.failed("新增的费率信息为空");
		}
		String insuranceTypeId = insuranceTypeRate.getInsuranceTypeId();
		TInsuranceType byId = insuranceTypeService.getById(insuranceTypeId);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("该险种信息不存在或已被删除");
		}
		String month = insuranceTypeRate.getMonth();
		if (!ValidityUtil.validatePositiveInt(month)){
			return R.failed("月份格式不正确");
		}
		String rate = insuranceTypeRate.getRate();
		if (!ValidityUtil.validateMoney(rate)){
			return R.failed("费率格式不正确");
		}
		LambdaQueryWrapper<TInsuranceTypeRate> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeRate::getDeleteFlag, CommonConstants.ZERO_INT).eq(TInsuranceTypeRate::getInsuranceTypeId,insuranceTypeId)
				.eq(TInsuranceTypeRate:: getMonth ,insuranceTypeRate.getMonth());
		List<TInsuranceTypeRate> list = this.list(queryWrapper);
		if (list.isEmpty()){
			insuranceTypeRate.setDeleteFlag(CommonConstants.ZERO_INT);
			insuranceTypeRate.setCreateBy(user.getId());
			insuranceTypeRate.setCreateName(user.getNickname());
			insuranceTypeRate.setCreateTime(LocalDateTime.now());
			save(insuranceTypeRate);
			addOperate(insuranceTypeRate,user, InsurancesConstants.NEW_INSURANCE_TYPE_RATE);
			return R.ok("新增费率信息成功");
		}else{
			return R.failed("该险种购买月份已存在");
		}
	}

	/**
	 * 操作记录
	 *
	 * @author zhaji
	 * @param insuranceTypeRate 费率信息
	 * @param user 登录用户
	 * @param operateDesc 操作描述
	 * @return void
	 */
	private void addOperate(TInsuranceTypeRate insuranceTypeRate,YifuUser user,String operateDesc){
		try {
			TInsuranceOperate operate = new TInsuranceOperate();
			operate.setInsuranceDetailId(insuranceTypeRate.getId());
			operate.setOperateDesc(operateDesc);
			operate.setCreateBy(user.getId());
			operate.setCreateName(user.getNickname());
			operate.setCreateTime(LocalDateTime.now());
			tInsuranceOperateService.save(operate);
		}catch (Exception e){
			e.getStackTrace();
		}
	}
}
