package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprEkpProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author huyc
 * @Description 定时任务具体执行类
 * @Date 10:48 2022/8/17
 * @Param
 * @return
 **/
@Component(value = "ekpTask")
@Slf4j
@EnableConfigurationProperties(DaprEkpProperties.class)
public class EkpTask {

	@Autowired
	private DaprEkpProperties daprEkpProperties;

	/**
	 * @Author huyc
	 * @Description 入账明细生成
	 * @Date 2024-8-28 16:31:32
	 * @Param
	 * @return
	 **/
	public void doCreateEntryInfoEkp() {
		log.info("------------定时生成入账明细数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/icbcQuery/inner/newPage","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成入账明细数据-定时任务结束------------");
	}

	/**
	 * @Author huyc
	 * @Description 昨日未生成的到账明细生成
	 * @Date 2024-8-28 16:31:32
	 * @Param
	 * @return
	 **/
	public void doCreateYesterdayEntryInfoEkp() {
		log.info("------------定时生成昨日未生成的入账明细数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/icbcQuery/inner/newPageYesterday","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成昨日未生成的入账明细数据-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 每小时获取银企付款结果
	 * @Date 2024-11-22 16:52:28
	 **/
	public void doGetEkpBankStatus() {
		log.info("------------每小时获取银企付款结果-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/icbcIssue/inner/doGetEkpBankStatus","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------每小时获取银企付款结果-定时任务结束------------");
	}

	/**
	 * @Author huyc
	 * @Description 生成昨日的回单文件
	 * @Date 2025-5-19 15:21:28
	 * @Param
	 * @return
	 **/
	public void doCreateYesterdayPdfFile() {
		log.info("------------定时生成生成昨日的回单文件-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/icbcIssue/inner/getPdfFile","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成生成昨日的回单文件-定时任务结束------------");
	}

	/**
	 * @Author fxj
	 * @Description 每日预算预警信息
	 * @Date 16:49 2025/7/21
	**/
	public void pushBudgetAlertInfoTomanager() {
		log.info("------------定时生成每日预算预警信息-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/ekpalerttable/inner/pushBudgetAlertInfoTomanager","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成生每日预算预警信息-定时任务结束------------");
	}
	/**
	 * @Author fxj
	 * @Description 每月预算预警信息
	 * @Date 16:49 2025/7/21
	 **/
	public void pushBudgetAlertInfoTomanagerMonth() {
		log.info("------------定时生成每月预算预警信息-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/ekpalerttable/inner/pushBudgetAlertInfoTomanagerMonth","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成每月预算预警信息-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 每天获取招行卡流水
	 * @Date 2025-9-9 17:22:21
	 **/
	public void doGetZhaoHangInfo() {
		log.info("------------每天获取招行卡流水-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId()
				,"/zhaoHang/inner/doGetZhaoHangInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------每天获取招行卡流水-定时任务结束------------");
	}

	/**
	 * @Author fxj
	 * @Description 微智能表格数据-定时任务
	 * @Date 9:41 2025/10/9
	**/
	public void wxExcelApi() {
		log.info("------------定时生成企微智能表格数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpProperties.getAppUrl(),daprEkpProperties.getAppId(),"/qwExcelApi/inner/wxExcelApi","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成企微智能表格数据-定时任务结束------------");
	}
}