package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 节点超时配置表
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_node_timeout_config")
@Schema(description = "节点超时配置表")
public class TNodeTimeoutConfig extends Model<TNodeTimeoutConfig> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;

     @NotBlank(message = "流程是否超时（0不超时/1指定时长/2脚本）不能为空")
     @Length(max = 1, message = "流程是否超时（0不超时/1指定时长/2脚本）不能超过1个字符")
	 @Schema(description = "流程是否超时（0不超时/1指定时长/2脚本）")
     private String timeOut;

     @Schema(description = "天数（TIME_OUT为2时启用）")
     private Integer day;

	 @Schema(description = "小时（TIME_OUT为2时启用）")
     private Integer hour;

     @Length(max = 1, message = "是否仅计算工作时间（TIME_OUT为2时启用，0是/1否）不能超过1个字符")
	 @Schema(description = "是否仅计算工作时间（TIME_OUT为2时启用，0是/1否）")
     private String workHourFlag;

     @NotBlank(message = "节点ID不能为空")
     @Length(max = 255, message = "节点ID不能超过255个字符")
	 @Schema(description = "节点ID")
     private String nodeId;
}
