package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.SysMessageSalary;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 最低工资提醒-临时人员连续购买最低工资次数
 *
 * @author wangan
 * @date 2019-11-21 17:18:10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Tag(name = "最低工资提醒-临时人员连续购买最低工资次数")
public class SysMessageSalaryTemplExportVo extends SysMessageSalary {
    private static final long serialVersionUID = 1L;


    @TableField(exist = false)
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "lastOneReasonType")
    @ExcelAttribute(name = "前一月原因大类",  maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SYS_MESSAGE_SALARY_TYPE, needExport = true)
    private Integer lastOneReasonType;


    @TableField(exist = false)
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "lastTwoReasonType")
    @ExcelAttribute(name = "前二月原因大类",  maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SYS_MESSAGE_SALARY_TYPE, needExport = true)
    private Integer lastTwoReasonType;


    @TableField(exist = false)
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "lastThreeReasonType")
    @ExcelAttribute(name = "前三月原因大类", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SYS_MESSAGE_SALARY_TYPE)
    private Integer lastThreeReasonType;

    @ExcelAttribute(name = "前三月原因大类", maxLength = 32, needExport = true)
    private Integer times;
}
