/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardOriginalDetail;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 薪资原表识别导入
 *
 * @author hgw
 * @date 2024-4-2 11:57:29
 */
@Mapper
public interface TSalaryStandardOriginalDetailMapper extends BaseMapper<TSalaryStandardOriginalDetail> {
	/**
	 * 薪资原表识别导入-分页
	 */
	IPage<TSalaryStandardOriginalDetail> getTSalaryStandardOriginalDetailPage(Page<TSalaryStandardOriginalDetail> page
			, @Param("tSalaryStandardOriginalDetail") TSalaryStandardOriginalDetail tSalaryStandardOriginalDetail);

	/**
	 * 薪资原表识别导入-分页
	 */
	List<TSalaryStandardOriginalDetail> getTSalaryStandardOriginalDetailByOrgId(@Param("originalId") String originalId);

	/**
	 * @Description: 删除关系
	 * @Author: hgw
	 * @Date: 2024/4/3 15:42
	 * @return: int
	 **/
	int deleteByOrgId(@Param("originalId") String originalId);

}
