/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
@Data
@TableName("t_auto_payment_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "自动化实缴记录表")
public class TAutoPaymentDetail extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelIgnore
	@Schema(description = "id")
	private String id;
	/**
	 * 是否重新办理 0 是 1 否
	 */
	@ExcelAttribute(name = "是否重新办理 0 是 1 否", maxLength = 1, readConverterExp = "0=是,1=否")
	@Length(max = 1, message = "是否重新办理 0 是 1 否不能超过1个字符")
	@ExcelProperty("是否重新办理")
	@Schema(description = "是否重新办理 0 是 1 否")
	private String repeatHandleFlag;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 32)
	@Length(max = 32, message = "姓名不能超过32个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 证件类型
	 */
	@ExcelAttribute(name = "证件类型", maxLength = 50)
	@Length(max = 50, message = "证件类型不能超过50个字符")
	@ExcelProperty("证件类型")
	@Schema(description = "证件类型")
	private String certType;
	/**
	 * 证件号码
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 50)
	@Length(max = 50, message = "证件号码不能超过50个字符")
	@ExcelProperty("证件号码")
	@Schema(description = "证件号码")
	private String certNum;
	/**
	 * 缴费工资
	 */
	@ExcelAttribute(name = "缴费工资")
	@ExcelProperty("缴费工资")
	@Schema(description = "缴费工资")
	private BigDecimal paymentSalary;
	/**
	 * 缴费基数
	 */
	@ExcelAttribute(name = "缴费基数")
	@ExcelProperty("缴费基数")
	@Schema(description = "缴费基数")
	private BigDecimal paymentBase;
	/**
	 * 费率
	 */
	@ExcelAttribute(name = "费率", maxLength = 10)
	@Length(max = 10, message = "费率不能超过10个字符")
	@ExcelProperty("费率")
	@Schema(description = "费率")
	private String rate;
	/**
	 * 应缴费额
	 */
	@ExcelAttribute(name = "应缴费额")
	@ExcelProperty("应缴费额")
	@Schema(description = "应缴费额")
	private BigDecimal payLimit;
	/**
	 * 人员编号
	 */
	@ExcelAttribute(name = "人员编号", maxLength = 32)
	@Length(max = 32, message = "人员编号不能超过32个字符")
	@ExcelProperty("人员编号")
	@Schema(description = "人员编号")
	private String empCode;
	/**
	 * 险种
	 */
	@ExcelAttribute(name = "险种", maxLength = 50)
	@Length(max = 50, message = "险种不能超过50个字符")
	@ExcelProperty("险种")
	@Schema(description = "险种")
	private String insuranceType;
	/**
	 * 社保缴纳月份
	 */
	@ExcelAttribute(name = "社保缴纳月份", maxLength = 10)
	@Length(max = 10, message = "社保缴纳月份不能超过10个字符")
	@ExcelProperty("社保缴纳月份")
	@Schema(description = "社保缴纳月份")
	private String payMonth;
	/**
	 * 社保生成月份
	 */
	@ExcelAttribute(name = "社保生成月份", maxLength = 10)
	@Length(max = 10, message = "社保生成月份不能超过10个字符")
	@ExcelProperty("社保生成月份")
	@Schema(description = "社保生成月份")
	private String createMonth;
	/**
	 * 社保缴纳地
	 */
	@ExcelAttribute(name = "社保缴纳地", maxLength = 50)
	@Length(max = 50, message = "社保缴纳地不能超过50个字符")
	@ExcelProperty("社保缴纳地")
	@Schema(description = "社保缴纳地")
	private String socialAddress;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户", maxLength = 100)
	@Length(max = 100, message = "社保户不能超过100个字符")
	@ExcelProperty("社保户")
	@Schema(description = "社保户")
	private String socialSecurityAccount;
	/**
	 * 资源类型：1日常申报导出；2单位个人缴费信息查询；3单位缴费明细查询；4单位缴费明细下载
	 */
	@ExcelAttribute(name = "资源类型", maxLength = 100, readConverterExp = "1=日常申报导出,2=单位个人缴费信息查询,3=单位缴费明细查询,4=单位缴费明细下载")
	@Length(max = 100, message = "资源类型不能超过100个字符")
	@ExcelProperty("资源类型")
	@Schema(description = "资源类型：1日常申报导出；2单位个人缴费信息查询；3单位缴费明细查询；4单位缴费明细下载")
	private String sourceType;

	/**
	 * 主表ID
	 */
	@ExcelAttribute(name = "主表ID", isNotEmpty = true, errorInfo = "主表ID不能为空", maxLength = 32)
	@NotBlank(message = "主表ID不能为空")
	@Length(max = 32, message = "主表ID不能超过32个字符")
	@ExcelIgnore
	@Schema(description = "主表ID")
	private String parentId;

}
