/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutRelDict;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysOutRelDictMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutRelDictService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;

/**
 * 外部字典与皖信字典的映射关系表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Log4j2
@Service
public class SysOutRelDictServiceImpl extends ServiceImpl<SysOutRelDictMapper, SysOutRelDict> implements SysOutRelDictService {

	@Override
	public List<SysOutRelDict> noPageDiy(SysOutRelDict searchVo) {
		LambdaQueryWrapper<SysOutRelDict> wrapper = buildQueryWrapper(searchVo);

		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(SysOutRelDict entity) {
		LambdaQueryWrapper<SysOutRelDict> wrapper = Wrappers.lambdaQuery();
		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(SysOutRelDict::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
