package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Set;


/**
 * @author pwang
 * @date 2019-11-05 15:24:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_prove_record")
@Schema(description = "工资证明记录表")
public class TProveRecord extends Model<TProveRecord> {
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	private String id;
	/**
	 * 员工id
	 */
	@NotBlank(message = "员工id不能为空")
	@Length(max = 32, message = "员工id不能超过32个字符")
	private String employeeInfo;
	/**
	 * 员工姓名
	 *
	 * @Author pwang
	 * @Date 2019-11-07 10:27
	 * @return
	 **/
	@Schema(description = "员工姓名")
	@ExcelAttribute(name = "员工姓名")
	@NotBlank(message = "员工姓名不能为空")
	@ExcelProperty("员工姓名")
	private String employeeName;
	/**
	 * 员工身份证号
	 *
	 * @Author pwang
	 * @Date 2019-11-07 10:27
	 * @return
	 **/
	@Schema(description = "身份证号")
	@NotBlank(message = "身份证号不能为空")
	@ExcelAttribute(name = "身份证号")
	@ExcelProperty("身份证号")
	private String employeeIdCard;
	/**
	 * 结算主体（部门）名称
	 *
	 * @Author pwang
	 * @Date 2019-11-07 10:27
	 * @return
	 **/
	@Schema(description = "项目名称")
	@NotBlank(message = "项目名称不能为空")
	@ExcelAttribute(name = "项目名称")
	@ExcelProperty("项目名称")
	private String employeeSettleDepartName;
	/**
	 *
	 */
	private String creatUser;
	@Schema(description = "开具人")
	@ExcelAttribute(name = "开具人")
	@ExcelProperty("开具人")
	private String creatUserName;
	/**
	 * 创建日期
	 */
	@Schema(description = "开具日期", name = "creatDate")
	@ExcelAttribute(name = "开具日期")
	@ExcelProperty("开具日期")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date creatDate;
	/**
	 * 开始月份
	 */
	@NotBlank(message = "开始月份不能为空")
	@Length(max = 6, message = "开始月份(yyyyMM)不能超过6个字符")
	@ExcelAttribute(name = "开始月份", isNotEmpty = true, errorInfo = "不能为空", maxLength = 6)
	@Schema(description = "开始月份", name = "startMonth")
	@ExcelProperty("开始月份")
	private String startMonth;
	/**
	 * 结束月份
	 */
	@NotBlank(message = "结束月份不能为空")
	@Length(max = 6, message = "结束月份(yyyyMM)不能超过6个字符")
	@ExcelAttribute(name = "结束月份", isNotEmpty = true, errorInfo = "不能为空", maxLength = 6)
	@Schema(description = "结束月份", name = "endMonth")
	@ExcelProperty("结束月份")
	private String endMonth;
	/**
	 * 计算的工资
	 */
	@NotNull(message = "计算的工资不能为空")
	@ExcelAttribute(name = "计算的工资")
	@Schema(description = "计算的工资（数据库数字）", name = "salary")
	private BigDecimal salary;
	/**
	 * 证明的工资
	 */
	@NotNull(message = "证明的工资不能为空")
	@ExcelAttribute(name = "平均工资")
	@Schema(description = "证明的工资（显示的数字）", name = "proveSalary")
	@ExcelProperty("平均工资")
	private BigDecimal proveSalary;
	/**
	 * 是否作废 0否1是
	 */
	@Length(max = 1, message = "是否作废不能超过1个字符")
	@ExcelAttribute(name = "是否作废", dataType = "isInvalid", isDataId = true)
	@ExcelProperty("是否作废")
	private String isInvalid;
	/**
	 * 作废原因
	 */
	@Length(max = 100, message = "作废原因不能超过100个字符")
	@ExcelAttribute(name = "作废原因")
	@ExcelProperty("作废原因")
	@Schema(description = "作废原因", name = "invalidReason")
	private String invalidReason;
	/**
	 * 证明编号
	 */
	@Length(max = 20, message = "证明编号不能超过20个字符")
	@ExcelAttribute(name = "证明编号")
	@Schema(description = "证明编号", name = "no")
	@ExcelProperty("证明编号")
	private String no;
	/**
	 * 用途
	 */
	@Length(max = 100, message = "用途不能超过100个字符")
	@ExcelAttribute(name = "用途")
	@Schema(description = "用途", name = "purpose")
	@ExcelProperty("用途")
	private String purpose;
	/**
	 * 0实发平均1应发平均
	 */
	@NotBlank(message = "实发应发不能为空")
	@Length(max = 1, message = "实发应发不能超过1个字符")
	@ExcelAttribute(name = "计算类型", dataType = "sumType", isDataId = true)
	@Schema(description = "0实发平均1应发平均", name = "sumType")
	@ExcelProperty("计算类型")
	private String sumType;
	/**
	 * 证明类型 0正式员工证明1试用期员工证明
	 */
	@NotBlank(message = "证明类型不能为空")
	@Length(max = 1, message = "证明类型不能超过1个字符")
	@Schema(description = "证明类型 0正式员工证明1试用期员工证明", name = "proveType")
	private String proveType;
	/**
	 * 打印次数
	 */
	@ExcelAttribute(name = "打印次数")
	@Schema(description = "打印次数", name = "number")
	private Integer number;
	/**
	 *
	 */
	@NotBlank(message = "单位全称不能为空")
	@Length(max = 100, message = "不能超过100个字符")
	@Schema(description = "单位全称", name = "unitName")
	private String unitName;
	/**
	 *
	 */
	@NotBlank(message = "单位地址不能为空")
	@Length(max = 100, message = "不能超过100个字符")
	@Schema(description = "单位地址", name = "unitAddr")
	private String unitAddr;
	/**
	 * 单位固定电话
	 */
	@NotBlank(message = "单位固定电话不能为空")
	@Length(max = 20, message = "单位固定电话不能超过20个字符")
	@Schema(description = "单位固定电话", name = "phone")
	private String phone;
	/**
	 * 合同结束时间
	 */
	@Schema(description = "合同结束时间")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date contractEndDate;
	/**
	 * 入职时间
	 */
	@Schema(description = "入职时间")
	private LocalDate entryDate;
	/**
	 * 合同类型
	 */
	@Schema(description = "合同类型")
	private String contractType;

	/**
	 * 岗位
	 *
	 * @Author
	 * @Date 2019-11-07 10:27pwang
	 * @return
	 **/
	@Schema(description = "岗位")
	private String post;
	@Schema(description = "计算月份数")
	private Integer mouthCount;
	/**
	 * 申请人部门所在城市id
	 *
	 * @Author pwang
	 * @Date 2019-11-07 18:18
	 * @param null
	 * @return
	 **/
	private String belongDepartCity;

	/**
	 * 根据证明工资手动在方法中转换NumberToCN.number2CNMontrayUnit(re.getProveSalary())
	 *
	 * @Author pwang
	 * @Date 2019-11-07 10:43
	 * @return
	 **/
	@Schema(description = "大写")
	@TableField(exist = false)
	private String capital;

	@TableField(exist = false)
	private List<String> idList;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

	@TableField(exist = false)
	@Schema(description = "查询limit  开始")
	private int limitStart;

	@TableField(exist = false)
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

}
