package com.yifu.cloud.plus.v1.yifu.archives.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractAttachInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeProjectMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeLogService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeProjectNewOldVO;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 主要执行人员档案的员工类型同步更新
 * @author huyc
 * @Date 2022-07-08
 * @Description 多线程的执行demo
 */
@Slf4j
@Component
public class DoJointTask {

    @Autowired
    private TEmployeeInfoService tEmployeeInfoService;

	@Autowired
	private TEmployeeProjectMapper tEmployeeProjectMapper;

	@Autowired
	private TEmployeeLogService tEmployeeLogService;

    /**
     * @Description: 合同-批量更换负责人
     * @Author: huyc
     * @Date: 2022-7-8
     * @return: void
     **/
    @Async
    public void doUpdateEmployeeInfo(List<TEmployeeInfo> tEmployeeInfoList, YifuUser user) {
        log.info("档案-批量更新人员档案-线程开始");
        try {
			List<TEmployeeProject> list;
			TEmployeeInfo tEmployeeInfoOld;
			for(TEmployeeInfo tEmployeeInfo:tEmployeeInfoList) {
				tEmployeeInfoOld = tEmployeeInfoService.getById(tEmployeeInfo.getId());
				//查询该人员所有的项目档案
				list = tEmployeeProjectMapper.selectList(Wrappers.<TEmployeeProject>query().lambda()
						.eq(TEmployeeProject::getEmpIdcard, tEmployeeInfo.getEmpIdcard())
						.eq(TEmployeeProject::getDeleteFlag, CommonConstants.STATUS_NORMAL)
						.eq(TEmployeeProject::getProjectStatus, CommonConstants.ZERO_INT));
				if (Common.isNotNull(list)) {
					Set<String> empNatrue = list.stream().map(TEmployeeProject::getEmpNatrue).collect(Collectors.toSet());
					if (empNatrue.stream().anyMatch(e -> e.equals(CommonConstants.THREE_STRING))) {
						tEmployeeInfo.setEmpNatrue(CommonConstants.THREE_STRING);
					} else if (empNatrue.stream().anyMatch(e -> e.equals(CommonConstants.ZERO_STRING))) {
						tEmployeeInfo.setEmpNatrue(CommonConstants.ZERO_STRING);
					} else if (empNatrue.stream().anyMatch(e -> e.equals(CommonConstants.ONE_STRING))) {
						tEmployeeInfo.setEmpNatrue(CommonConstants.ONE_STRING);
					} else {
						tEmployeeInfo.setEmpNatrue(CommonConstants.TWO_STRING);
					}
					tEmployeeInfo.setProjectNum(list.size());
				} else {
					tEmployeeInfo.setProjectNum(CommonConstants.ZERO_INT);
				}
				tEmployeeInfoService.updateById(tEmployeeInfo);
				tEmployeeLogService.saveModificationRecord(CommonConstants.dingleDigitIntArray[0]
						, tEmployeeInfo.getId(), "", tEmployeeInfoOld, tEmployeeInfo,user);
			}
        } catch (Exception e) {
            log.error("档案-批量更新人员档案错误", e);
        }
        log.info("档案-批量更新人员档案结束");
    }

	/**
	 * @Description: 合同-批量更换负责人
	 * @Author: huyc
	 * @Date: 2022-7-8
	 * @return: void
	 **/
	@Async
	public void updateFddEmployeeInfo(List<TEmployeeInfo> tEmployeeInfoList, FddContractAttachInfo fddContractAttachInfo) {
		log.info("法大大档案-批量更新人员档案-线程开始");
		try {
			TEmployeeInfo tEmployeeInfoOld;
			List<TEmployeeProject> list;
			for(TEmployeeInfo tEmployeeInfo:tEmployeeInfoList) {
				tEmployeeInfoOld = tEmployeeInfoService.getById(tEmployeeInfo.getId());
				//查询该人员所有的项目档案
				list = tEmployeeProjectMapper.selectList(Wrappers.<TEmployeeProject>query().lambda()
						.eq(TEmployeeProject::getEmpIdcard, tEmployeeInfo.getEmpIdcard())
						.eq(TEmployeeProject::getDeleteFlag, CommonConstants.STATUS_NORMAL)
						.eq(TEmployeeProject::getProjectStatus, CommonConstants.ZERO_INT));
				if (Common.isNotNull(list)) {
					Set<String> empNatrue = list.stream().map(TEmployeeProject::getEmpNatrue).collect(Collectors.toSet());
					if (empNatrue.stream().anyMatch(e -> e.equals(CommonConstants.ZERO_STRING))) {
						tEmployeeInfo.setEmpNatrue(CommonConstants.ZERO_STRING);
					} else if (empNatrue.stream().anyMatch(e -> e.equals(CommonConstants.ONE_STRING))) {
						tEmployeeInfo.setEmpNatrue(CommonConstants.ONE_STRING);
					} else {
						tEmployeeInfo.setEmpNatrue(CommonConstants.TWO_STRING);
					}
					tEmployeeInfo.setProjectNum(list.size());
				} else {
					tEmployeeInfo.setProjectNum(CommonConstants.ZERO_INT);
				}
				tEmployeeInfoService.updateById(tEmployeeInfo);
				tEmployeeLogService.saveModificationRecord(CommonConstants.dingleDigitIntArray[0]
						, tEmployeeInfo.getId(), "", tEmployeeInfoOld, tEmployeeInfo,fddContractAttachInfo);
			}
		} catch (Exception e) {
			log.error("法大大档案-批量更新人员档案错误", e);
		}
		log.info("法大大档案-批量更新人员档案结束");
	}

	/**
	 * @Description: 更新项目档案操作记录
	 * @Author: huyc
	 * @Date: 2022-11-22
	 * @return: void
	 **/
	@Async
	public void saveModificationRecord(List<EmployeeProjectNewOldVO> updateProjectList,YifuUser user) {
		try {
			for (EmployeeProjectNewOldVO newOldVO : updateProjectList) {
				tEmployeeLogService.saveModificationRecord(CommonConstants.dingleDigitIntArray[1],""
						, newOldVO.getNewProjectEmployee().getId(), newOldVO.getOldProjectEmployee(),
						newOldVO.getNewProjectEmployee(),user);
			}
		} catch (Exception e) {
			log.error("档案-更新项目档案操作记录错误", e);
		}
		log.info("档案-更新项目档案操作记录结束");
	}
}
