package com.yifu.cloud.plus.v1.business.query.vacation;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 假期监控表 分页查询query
 * @author: wangweiguo
 * @date: 2021-08-13
*/
@Setter
@Getter
@ToString
public class TVacationMonitorQuery implements Serializable  {

    /**
     * 电信工号
     */
	@Schema(description = "电信工号")
	private String businessTelecomNumber;

    /**
     * 姓名
     */
	@Schema(description = "姓名")
	private String empName;

    /**
     * 身份证号码
     */
	@Schema(description = "身份证号码")
	private String empIdcard;

    /**
     * b端岗位
     */
	@Schema(description = "岗位")
	private String businessPost;

    /**
     * 部门id
     */
	@Schema(description = "所属部门treeLogo")
	private Integer departId;

    /**
     * 年份
     */
	@Schema(description = "年份")
	private String vacationYear;

    /**
     * 休假状态 0剩余未休 1已休
     */
	@Schema(description = "休假状态 0剩余未休 1已休")
	private String vacationStatus;

    /**
    * 当前页码 默认为1
    */
	@Schema(description = "当前页码 默认为1")

	long current = 1;

    /**
    * 每页数量 默认为10
    */
	@Schema(description = "每页数量 默认为10")

	long size = 10;

    /**
    * 排序字段
    */
	@Schema(description = "排序字段")
	List<OrderItem> orders;
}

