package com.yifu.cloud.plus.v1.business.controller.system;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarningEmployee;
import com.yifu.cloud.plus.v1.business.service.system.TBusWarningEmployeeService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * B端短信发送记录表
 *
 * @author hgw
 * @date 2021-08-23 16:27:34
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tbuswarningemployee")
@Tag(name = "B端短信发送记录表")
public class TBusWarningEmployeeController {

     private final TBusWarningEmployeeService tBusWarningEmployeeService;

     /**
      * 简单分页查询
      *
      * @param page                分页对象
      * @param tBusWarningEmployee B端短信发送记录表
      * @return
      */
	 @Operation(summary = "简单分页查询", description = "简单分页查询")
	 @GetMapping("/page")
     public R<IPage<TBusWarningEmployee>> getTBusWarningEmployeePage(Page<TBusWarningEmployee> page, TBusWarningEmployee tBusWarningEmployee) {
          return new R<>(tBusWarningEmployeeService.getTBusWarningEmployeePage(page, tBusWarningEmployee));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询", description = "id查询")
	 @GetMapping("/{id}")
     public R<TBusWarningEmployee> getById(@PathVariable("id") String id) {
          return new R<>(tBusWarningEmployeeService.getById(id));
     }

     /**
      * @param se
      * @Description: 手动发送
      * @Author: hgw
      * @Date: 2021-8-23 17:15:28
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSmsEmployee>
      **/
	 @Operation(summary = "手动发送-单个", description = "手动发送-单个")
	 @PostMapping("/sendBusSms")
     public R<String> sendBusSms(@RequestBody TBusWarningEmployee se) {
          return tBusWarningEmployeeService.sendBusSms(se);
     }

}
