package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpShenhepeizhi;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpShenhepeizhiMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpShenhepeizhiService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpDivisionInfoVo;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 事业部审批配置
 * @author chenyuxi
 * @date 2025/1/15
 * @since 1.7.5
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class EkpShenhepeizhiServiceImpl extends ServiceImpl<EkpShenhepeizhiMapper, EkpShenhepeizhi> implements EkpShenhepeizhiService {

	@Override
	public EkpDivisionInfoVo getDivisionUsernameList(EkpDivisionInfoVo divisionInfoVo) {
		EkpDivisionInfoVo divisionInfoVoRes = new EkpDivisionInfoVo();
		List<String> divisionUsernameList = new ArrayList<>();
		// 指定事业部配置表负责人标识：0事业部条线负责人；1事业部负责人；2分管副总
		if(CommonConstants.ZERO_STRING.equals(divisionInfoVo.getDivisionIdentification())){
			divisionUsernameList = baseMapper.getLineLoginNameList(divisionInfoVo.getNewLine(), divisionInfoVo.getDivision());
		}
		if(CommonConstants.ONE_STRING.equals(divisionInfoVo.getDivisionIdentification())){
			divisionUsernameList = baseMapper.getDivisionLoginNameList(divisionInfoVo.getNewLine(), divisionInfoVo.getDivision());
		}
		if(CommonConstants.TWO_STRING.equals(divisionInfoVo.getDivisionIdentification())){
			divisionUsernameList = baseMapper.getFuLoginNameList(divisionInfoVo.getNewLine(), divisionInfoVo.getDivision());
		}
		divisionInfoVoRes.setDivisionUsernameList(divisionUsernameList);
		return divisionInfoVoRes;
	}


}
