package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 商险办理替换入参
 * @date 2022-07-20 08:43:31
 */
@Data
@Schema(description = "商险办理替换入参")
public class InsuranceReplaceParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 替换员工姓名
	 */
	@Schema(description = "替换员工姓名")
	private String replaceEmpName;

	/**
	 * 替换员工身份证号
	 */
	@Schema(description = "替换员工身份证号")
	private String replaceEmpIdcardNo;

	/**
	 * 替换员工项目编码
	 */
	@Schema(description = "替换员工项目编码")
	private String replaceDeptNo;

	/**
	 * 岗位
	 */
	@Schema(description = "岗位")
	private String post;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

	/**
	 * 商险待购买id
	 */
	@Schema(description = "商险待购买id")
	private String insurancePreId;

	/**
	 * 数据传递对象
	 */
	@JsonIgnore
	private TInsuranceDetail detail;

	/***********************************以下字段由系统算出，前端不用传，是为了方便入库***********************************/
	/**
	 * 结算类型 (1、单独结算 2、合并结算-和工资一起结算)
	 */
	@JsonIgnore
	private Integer settleType;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description ="客户id")
	private String unitId;

	@Schema(description ="客户名称")
	private String unitName;

	@Schema(description ="客户编码")
	private String unitNo;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;


	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

}
