package com.yifu.cloud.plus.v1.yifu.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.process.entity.TProcess;
import com.yifu.cloud.plus.v1.yifu.process.entity.TProcessApprovalConf;
import com.yifu.cloud.plus.v1.yifu.process.mapper.TProcessApprovalConfMapper;
import com.yifu.cloud.plus.v1.yifu.process.service.TProcessApprovalConfService;
import com.yifu.cloud.plus.v1.yifu.process.service.TProcessService;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants.SEARCH_SUCCESS;

/**
 * 审批配置表
 *
 * @author wangan
 * @date 2020-12-03 09:58:15
 */
@Service
public class TProcessApprovalConfServiceImpl extends ServiceImpl<TProcessApprovalConfMapper, TProcessApprovalConf> implements TProcessApprovalConfService {

	@Resource
	@Lazy
    private TProcessService tProcessService;

  /**
   * 审批配置表简单分页查询
   * @param tProcessApprovalConf 审批配置表
   * @return
   */
  @Override
  public IPage<TProcessApprovalConf> getTProcessApprovalConfPage(Page<TProcessApprovalConf> page, TProcessApprovalConf tProcessApprovalConf){
      return baseMapper.getTProcessApprovalConfPage(page,tProcessApprovalConf);
  }


    @Override
    public R<TProcessApprovalConf> getRecordByCondition(String type, String parentId, String fieldName, String fieldValue) {
        //存储流程配置信息
        List<TProcessApprovalConf> list = new ArrayList<>();
        //hro垫付不需查询在用的流程
        if (!CommonConstants.FOUR_STRING.equals(type)){
            /*
             * 1.查找所有在用的流程
             */
            List<TProcess> inUse = tProcessService.list(Wrappers.<TProcess>query().lambda()
                    .eq(TProcess::getDeleteFlag, CommonConstants.NOT_DELETE_FLAG)
                    .eq(TProcess::getProcessIsUse, CommonConstants.ZERO_STRING));

            /*
             * 2.将在用的流程过滤出id
             */
            //在用流程id存放集合
            List<String> inUseIdList = new ArrayList<>();
            //开始根据是否通用分组
            if (Common.isNotKong(inUse)){
                inUseIdList = inUse.stream().map(TProcess::getId).collect(Collectors.toList());
            }else {
                return R.failed("当前部门未配置在用流程");
            }

            /*
             * 3.获取当前部门流程配置
             */
            list = this.list(Wrappers.<TProcessApprovalConf>query().lambda()
                    .eq(TProcessApprovalConf::getType, type)
                    .eq(TProcessApprovalConf::getFieldName, fieldName)
                    .eq(TProcessApprovalConf::getFieldValue, fieldValue)
                    .eq(TProcessApprovalConf::getParentId, parentId)
                    .eq(TProcessApprovalConf::getDeleteFlag, CommonConstants.ZERO_STRING));

            List<TProcessApprovalConf> one = new ArrayList<>();
            /*
             * 4.当前部门配置流程未找到 找不到找在用的通用的流程
             */
            if (Common.isEmpty(list)) {
                //找在用的通用流程
                one = getCommonInUseProcess(type, inUseIdList);
                //4.1在用的通用流程未找到，报错
                if (Common.isEmpty(one)){
                    return R.failed("找不到流程");
                }
                //4.2当前类型的在用的通用流程找到不止一条
                if (one.size() > CommonConstants.ONE_INT){
                    return R.failed("当前类型在用的通用流程不止一条");
                }
                return R.ok(one.get(CommonConstants.ZERO_INT),SEARCH_SUCCESS);
            }

            /*
             * 5.当前部门配置流程找到了只有一条
             */
            //判断是否在 在用列表里
            if (list.size() == CommonConstants.ONE_INT){
                if (Common.isNotKong(inUseIdList) && inUseIdList.contains(list.get(CommonConstants.ZERO_INT).getProcessId())){
                    return R.ok(list.get(CommonConstants.ZERO_INT),SEARCH_SUCCESS);
                }else {
                    //找在用的通用流程
                    one = getCommonInUseProcess(type, inUseIdList);
                    //4.1在用的通用流程未找到，报错
                    if (Common.isEmpty(one)){
                        return R.failed("找不到流程");
                    }
                    //4.2当前类型的在用的通用流程找到不止一条
                    if (one.size() > CommonConstants.ONE_INT){
                        return R.failed("当前类型的在用的通用流程不止一条");
                    }
                    return R.ok(one.get(CommonConstants.ZERO_INT),SEARCH_SUCCESS);
                }
            }

            /*
             * 6.当前部门配置流程找到了多于一条
             */
            //返回在用的那一条流程
            one = new ArrayList<>();
            for (TProcessApprovalConf tProcessApprovalConf : list) {
                if (inUseIdList.contains(tProcessApprovalConf.getProcessId())){
                    one.add(tProcessApprovalConf);
                }
            }
            //在用流程和配置的流程一条都没匹配上，返回在用的通用流程
            if (one.isEmpty()) {
                //找在用的通用流程
                one = getCommonInUseProcess(type, inUseIdList);
                //4.1在用的通用流程未找到，报错
                if (Common.isEmpty(one)){
                    return R.failed("找不到流程");
                }
                //4.2当前类型的在用的通用流程找到不止一条
                if (one.size() > CommonConstants.ONE_INT){
                    return R.failed("当前类型的在用的通用流程不止一条");
                }
                return R.ok(one.get(CommonConstants.ZERO_INT),SEARCH_SUCCESS);
            }
            //在用流程和配置的流程匹配上了不止一条
            if (one.size() > CommonConstants.ONE_INT) {
                return R.failed("满足当前条件的流程不止一条");
            }
            //在用流程和配置的流程匹配上了一条
            return R.ok(one.get(CommonConstants.ZERO_INT),SEARCH_SUCCESS);

        }else {
            //垫付走原先流程
            list = this.list(Wrappers.<TProcessApprovalConf>query().lambda()
                    .eq(TProcessApprovalConf::getType, type).eq(TProcessApprovalConf::getFieldName, fieldName)
                    .eq(TProcessApprovalConf::getFieldValue, fieldValue).eq(TProcessApprovalConf::getParentId, parentId)
                    .eq(TProcessApprovalConf::getDeleteFlag, CommonConstants.ZERO_STRING));

            if (list.isEmpty()) {
                return new R<>(null);
            }
            if (list.size() > CommonConstants.ONE_INT) {
                return R.failed("满足当前条件的流程不为一条");
            }

            return new R<>(list.get(CommonConstants.ZERO_INT));
        }
    }

    private List<TProcessApprovalConf> getCommonInUseProcess(String type, List<String> inUseIdList) {
        LambdaQueryWrapper<TProcessApprovalConf> query = new LambdaQueryWrapper<>();
        //获取该类型下面的流程配置,并判断当前类型的流程是否是在用流程，若是，则提示重复，否则正常保存
        query.eq(TProcessApprovalConf::getType, type)
                .eq(TProcessApprovalConf::getDeleteFlag, CommonConstants.ZERO_STRING)
                .and(wq -> wq.isNull(TProcessApprovalConf::getFieldValue).or()
                        .eq(TProcessApprovalConf::getFieldValue, CommonConstants.EMPTY_STRING));
        List<TProcessApprovalConf> commonProcess = this.list(query);
        List<TProcessApprovalConf> one = new ArrayList<>();
        if (Common.isNotKong(commonProcess)){
            for (TProcessApprovalConf process : commonProcess) {
                if (inUseIdList.contains(process.getProcessId())){
                    one.add(process);
                }
            }
        }
        return one;
    }
}
