/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * @author fxj
 * @date 2024-12-18 15:39:57
 */
@Data
@TableName("t_question_feedback_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "")
public class TQuestionFeedbackInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 反馈人姓名
	 */
	@ExcelAttribute(name = "反馈人姓名", isNotEmpty = true, errorInfo = "反馈人姓名不能为空", maxLength = 20)
	@NotBlank(message = "反馈人姓名不能为空")
	@Length(max = 20, message = "反馈人姓名不能超过20个字符")
	@ExcelProperty("反馈人姓名")
	@Schema(description = "反馈人姓名")
	private String name;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码",isPhone = true, isNotEmpty = true, errorInfo = "手机号码不能为空", maxLength = 20)
	@NotBlank(message = "手机号码不能为空")
	@Length(max = 20, message = "手机号码不能超过20个字符")
	@ExcelProperty("手机号码")
	@Schema(description = "手机号码")
	private String mobile;
	/**
	 * 你遇到的问题
	 */
	@ExcelAttribute(name = "你遇到的问题", maxLength = 200)
	@Length(max = 200, message = "你遇到的问题不能超过200个字符")
	@ExcelProperty("你遇到的问题")
	@Schema(description = "你遇到的问题")
	private String question;
	/**
	 * 处理状态：0待处理、1处理中、2已处理、3手动更新
	 */
	@ExcelAttribute(name = "处理状态：待处理、处理中、已处理、手动更新", maxLength = 10)
	@Length(max = 10, message = "处理状态：待处理、处理中、已处理、手动更新不能超过10个字符")
	@ExcelProperty("处理状态：待处理、处理中、已处理、手动更新")
	@Schema(description = "处理状态：待处理、处理中、已处理、手动更新")
	private String handleStatus;
	/**
	 * 处理人
	 */
	@ExcelAttribute(name = "处理人", maxLength = 20)
	@Length(max = 20, message = "处理人不能超过20个字符")
	@ExcelProperty("处理人")
	@Schema(description = "处理人")
	private String handleOperator;
	/**
	 * 处理完成时间
	 */
	@ExcelAttribute(name = "处理完成时间", isDate = true)
	@ExcelProperty("处理完成时间")
	@Schema(description = "处理完成时间")
	private Date handleFinishTime;
	/**
	 * 处理说明
	 */
	@ExcelAttribute(name = "处理说明", maxLength = 200)
	@Length(max = 200, message = "处理说明不能超过200个字符")
	@ExcelProperty("处理说明")
	@Schema(description = "处理说明")
	private String handleRemark;


	/**
	 * @Author fxj
	 * @Description 问题反馈附件ID
	 * @Date 16:49 2024/12/18
	 * @Param
	 * @return
	**/
	@TableField(exist = false)
	private String attaIds;
}
