/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 工资报账主表2022
 *
 * @author hgw
 * @date 2022-08-05 11:40:15
 */
@Data
@TableName("t_salary_account_2022")
@Schema(description = "工资报账主表-年度")
public class TSalaryAccount2022 {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 封面抬头
	 */
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;
	/**
	 * 员工 ID
	 */
	@ExcelAttribute(name = "员工 ID", maxLength = 32)
	@Length(max = 32, message = "员工 ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工 ID")
	private String empId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Length(max = 50, message = "员工姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@ExcelAttribute(name = "员工身份证号", maxLength = 25)
	@Length(max = 25, message = "员工身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工身份证号")
	private String empIdcard;
	/**
	 * 结算部门id
	 */
	@ExcelAttribute(name = "结算部门id", maxLength = 32)
	@Length(max = 32, message = "结算部门id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门id")
	private String settleDepartId;
	/**
	 * 结算部门no
	 */
	@ExcelAttribute(name = "结算部门no", maxLength = 50)
	@Length(max = 50, message = "结算部门no不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门no")
	private String settleDepartNo;
	/**
	 * 结算部门name
	 */
	@ExcelAttribute(name = "结算部门name", maxLength = 50)
	@Length(max = 50, message = "结算部门name不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门name")
	private String settleDepartName;
	/**
	 * 结算月
	 */
	@ExcelAttribute(name = "结算月", maxLength = 20)
	@Length(max = 20, message = "结算月不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月")
	private String settlementMonth;
	/**
	 * 计税月份
	 */
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	@Length(max = 6, message = "计税月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计税月份")
	private String taxMonth;
	/**
	 * 应发
	 */
	@ExcelAttribute(name = "应发")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发")
	private BigDecimal realSalary;
	/**
	 * 减除
	 */
	@ExcelAttribute(name = "减除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减除")
	private BigDecimal costReduction;
	/**
	 * 专项
	 */
	@ExcelAttribute(name = "专项")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("专项")
	private BigDecimal specialDeduMoney;
	/**
	 * 累计子女教育
	 */
	@ExcelAttribute(name = "累计子女教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计子女教育")
	private BigDecimal childEduinfoMoney;
	/**
	 * 累计住房贷款利息
	 */
	@ExcelAttribute(name = "累计住房贷款利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房贷款利息")
	private BigDecimal housingLoanInterestExpenseMoney;
	/**
	 * 累计住房租金
	 */
	@ExcelAttribute(name = "累计住房租金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金")
	private BigDecimal housingRentalinfoMoney;
	/**
	 * 累计继续教育
	 */
	@ExcelAttribute(name = "累计继续教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计继续教育")
	private BigDecimal continuingEducationExpenseMoney;
	/**
	 * 累计赡养老人
	 */
	@ExcelAttribute(name = "累计赡养老人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计赡养老人")
	private BigDecimal supportElderlyExpenseMoney;
	/**
	 * 个人社保
	 */
	@ExcelAttribute(name = "个人社保")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保")
	private BigDecimal personalSocial;
	/**
	 * 个人公积金
	 */
	@ExcelAttribute(name = "个人公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金")
	private BigDecimal personalFund;
	/**
	 * 代扣个人社保
	 */
	@ExcelAttribute(name = "代扣个人社保")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("代扣个人社保")
	private BigDecimal withholidingPersonSocial;
	/**
	 * 代扣个人公积金
	 */
	@ExcelAttribute(name = "代扣个人公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("代扣个人公积金")
	private BigDecimal withholidingPersonFund;
	/**
	 * 企业年金
	 */
	@ExcelAttribute(name = "企业年金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("企业年金")
	private BigDecimal enterpriseAnnuity;
	/**
	 * 个税
	 */
	@ExcelAttribute(name = "个税")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税")
	private BigDecimal salaryTax;
	/**
	 * 实发
	 */
	@ExcelAttribute(name = "实发")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("实发")
	private BigDecimal actualSalarySum;
	/**
	 * 年终奖(单独扣税的部分)
	 */
	@ExcelAttribute(name = "年终奖(单独扣税的部分)")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖(单独扣税的部分)")
	private BigDecimal annualBonus;
	/**
	 * 年终奖单独扣税
	 */
	@ExcelAttribute(name = "年终奖单独扣税")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖单独扣税")
	private BigDecimal annualBonusTax;
	/**
	 * 免个税个人代扣
	 */
	@ExcelAttribute(name = "免个税个人代扣")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("免个税个人代扣")
	private BigDecimal exemptionPersionTax;
	/**
	 * 单位id
	 */
	@ExcelAttribute(name = "单位id", maxLength = 32)
	@Length(max = 32, message = "单位id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位id")
	private String unitId;
	/**
	 * 单位no
	 */
	@ExcelAttribute(name = "单位no", maxLength = 50)
	@Length(max = 50, message = "单位no不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位no")
	private String unitNo;
	/**
	 * 单位name
	 */
	@ExcelAttribute(name = "单位name", maxLength = 50)
	@Length(max = 50, message = "单位name不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位name")
	private String unitName;
	/**
	 * 累计3岁以下婴幼儿照护
	 */
	@ExcelAttribute(name = "累计3岁以下婴幼儿照护")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;
	/**
	 * 是否当月新增人员
	 */
	@ExcelAttribute(name = "是否当月新增人员", readConverterExp = "0=否,1=是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否当月新增人员")
	private String isNewEmployee;
	/**
	 * 入职年月
	 */
	@ExcelAttribute(name = "入职年月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("入职年月")
	private String createMonth;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empPhone;

	@ExcelAttribute(name = "累计个人养老金", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计个人养老金")
	private BigDecimal sumPrivatePension;

}
