package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAuditNodeProcess;
import com.yifu.cloud.plus.v1.yifu.salary.service.TAuditNodeProcessService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 审批主流程记录表节点表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tauditnodeproocess" )
@Tag(name = "审批主流程记录表节点表管理")
public class TAuditNodeProocessController {

    private final TAuditNodeProcessService tAuditNodeProcessService;

    /**
     * 通过id查询审批主流程记录表节点表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('insurances_tauditnodeproocess_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('insurances_tauditnodeproocess_get')" )
    public R<TAuditNodeProcess> getById(@PathVariable("id" ) String id) {
        return R.ok(tAuditNodeProcessService.getById(id));
    }

    /**
     * 新增审批主流程记录表节点表
     * @param tAuditNodeProcess 审批主流程记录表节点表
     * @return R
     */
    @Operation(summary = "新增审批主流程记录表节点表", description = "新增审批主流程记录表节点表：hasPermission('insurances_tauditnodeproocess_add')")
    @SysLog("新增审批主流程记录表节点表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('insurances_tauditnodeproocess_add')" )
    public R<Boolean> save(@RequestBody TAuditNodeProcess tAuditNodeProcess) {
        return R.ok(tAuditNodeProcessService.save(tAuditNodeProcess));
    }

    /**
     * 修改审批主流程记录表节点表
     * @param tAuditNodeProcess 审批主流程记录表节点表
     * @return R
     */
    @Operation(summary = "修改审批主流程记录表节点表", description = "修改审批主流程记录表节点表：hasPermission('insurances_tauditnodeproocess_edit')")
    @SysLog("修改审批主流程记录表节点表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('insurances_tauditnodeproocess_edit')" )
    public R<Boolean> updateById(@RequestBody TAuditNodeProcess tAuditNodeProcess) {
        return R.ok(tAuditNodeProcessService.updateById(tAuditNodeProcess));
    }

    /**
     * 通过id删除审批主流程记录表节点表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除审批主流程记录表节点表", description = "通过id删除审批主流程记录表节点表：hasPermission('insurances_tauditnodeproocess_del')")
    @SysLog("通过id删除审批主流程记录表节点表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('insurances_tauditnodeproocess_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAuditNodeProcessService.removeById(id));
    }

}
